# 改进 Neural Network Intelligence (NNI)

欢迎！！ 我们非常欢迎贡献者，特别是代码贡献者。

首先，如果有什么不确定的事情，可随时提交问题或拉取请求。 不会有人因此而抱怨。:) 最有可能的是，会有礼貌的请求你修改一些内容。 我们会感激任何形式的贡献，不想用一堆规则来阻止这些贡献。

不管怎样，如果想要更有效的贡献代码，可以阅读以下内容。 本文档包括了所有在贡献中需要注意的要点，会加快合并代码、解决问题的速度。

查看[快速入门](./QuickStart.md)来初步了解。

下面是一些简单的贡献指南。

## 提交问题

在提出问题时，请说明以下事项：

- 按照问题模板的内容来填写安装的细节，以便评审者检查。
- 出现问题的场景 (尽量详细，以便重现问题)。
- 错误和日志消息。
- 其它可能有用的细节信息。

## 提交新功能建议

- 在适配使用场景时，总会需要一些新的功能。 可以加入新功能的讨论，也可以直接提交新功能的拉取请求。

- 在自己的 github 账户下 fork 存储库。 在 fork 后， 对于 add, commit, push, 或 squash (如需要) 等改动都需要详细的提交消息。 然后就可以提交拉取请求了。

## 参与源代码和 Bug 修复

拉取请求需要选好正确的标签，表明是 Bug 修复还是功能改进。 所有代码都需要遵循正确的命名约定和代码风格。

参考[如何配置 NNI 的开发环境](./SetupNNIDeveloperEnvironment.md)，来安装开发环境。

与[快速入门](QuickStart.md)类似。 其它内容，参考[NNI 文档](http://nni.readthedocs.io)。

## 处理现有问题

查看[问题列表](https://github.com/Microsoft/nni/issues)，找到需要贡献的问题。 可以找找有 'good-first-issue' 或 'help-wanted' 标签的来开始贡献。

修改问题的注释和指派人来表明此问题已经开始跟进。 如果上述问题在一周内没有拉取请求或更新状态，这个问题会重新开放给所有人。 高优先级的 Bug 和回归问题需在一天内响应。

## 代码风格和命名约定

NNI 遵循 [PEP8](https://www.python.org/dev/peps/pep-0008/) 的 Python 代码命名约定。在提交拉取请求时，请尽量遵循此规范。 可通过`flake8`或`pylint`的提示工具来帮助遵循规范。