_base_ = [
    'configs/_base_/models/resnet50.py', 'configs/_base_/datasets/tiny_imagenet_bs32.py',
    'configs/_base_/schedules/imagenet_bs256.py', 'configs/_base_/default_runtime.py'
]

import torch

torch.backends.cuda.matmul.allow_tf32=True
torch.backends.cudnn.allow_tf32=True

# optimizer
optim_wrapper = dict(
        #type='AmpOptimWrapper',
        #dtype='float16',
    optimizer=dict(type='SGD', lr=0.1, momentum=0.9, weight_decay=0.0001))

custom_hooks = [
        dict(type='ProfilerHook', by_epoch=False,
            profile_times=12,
            with_stack=True,
            with_flops=True,
            on_trace_ready=dict(type="log_trace", sort_by="self_cuda_time_total"),
            activity_with_cuda=True,
            schedule=dict(wait=1, warmup=1, active=10, repeat=1))
        ]
