_base_ = [
    'configs/_base_/models/inception_v3.py',
    'configs/_base_/datasets/tiny_imagenet_bs32.py',
    'configs/_base_/schedules/imagenet_bs256_coslr.py',
    'configs/_base_/default_runtime.py',
]

#import os
#import torch

#torch.backends.cuda.matmul.allow_tf32=True
#torch.backends.cudnn.allow_tf32=True

train_pipeline = [
    dict(type='LoadImageFromFile'),
    dict(type='RandomResizedCrop', scale=299),
    dict(type='RandomFlip', prob=0.5, direction='horizontal'),
    dict(type='PackInputs'),
]

test_pipeline = [
    dict(type='LoadImageFromFile'),
    dict(type='ResizeEdge', scale=342, edge='short'),
    dict(type='CenterCrop', crop_size=299),
    dict(type='PackInputs'),
]

train_dataloader = dict(dataset=dict(pipeline=train_pipeline))
val_dataloader = dict(dataset=dict(pipeline=test_pipeline))
test_dataloader = dict(dataset=dict(pipeline=test_pipeline))

# optimizer
optim_wrapper = dict(
        #type='AmpOptimWrapper',
        #dtype='bfloat16',
    optimizer=dict(type='SGD', lr=0.1, momentum=0.9, weight_decay=0.0001))

# 自定义hooks，添加ProfilerHook, 只在rank0启用
#custom_hooks = [
#    dict(type='ProfilerHook', by_epoch=False,
#        profile_times=5,
#        on_trace_ready=dict(type="log_trace", sort_by="self_cuda_time_total"),
#        json_trace_path=f"trace_inceptionv3_tf32.json",
#        activity_with_cuda=True,
#        schedule=dict(wait=3, warmup=1, active=1, repeat=1))  # 这样的设置是10次
#] if os.environ['LOCAL_RANK'] == '0' else []
