# MMPretrain-MMCV

## 环境配置

### Docker（方法一）

推荐使用docker方式运行，拉取提供的docker镜像

```shell
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10
```

基于拉取的镜像创建容器

```shell
# <your IMAGE ID or NAME>用以上拉取的docker的镜像ID或名称替换 
docker run -it --name=mmpretrain --network=host --ipc=host --shm-size=16g --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --privileged --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v /opt/yhal:/opt/hyhal:ro -v $PWD/mmpretrain_mmcv:/home/mmpretrain_mmcv <your IMAGE ID> bash
```

克隆git仓库，并安装相关依赖

```shell
git clone http://developer.hpccube.com/codes/OpenDAS/mmpretrain-mmcv.git
cd mmpretrain-mmcv 
pip install -e .
pip install -r requirements.txt
```

### Dockerfile（方法二）

    cd mmpretrain-mmcv/docker
    docker build --no-cache -t mmpretrain:latest .
    docker run -it --name=mmpretrain --network=host --ipc=host --shm-size=16g  --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --privileged --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v /opt/hyhal:/opt/hyhal:ro -v $PWD/mmpretrain:/home/mmpretrain <your IMAGE ID> bash
    pip install -e .
    # 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：
    pip install -r requirements.txt

### Anaconda（方法三）

1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.hpccube.com/tool/

```shell
DTK驱动: DTK-24.04.1 
python==3.10 
torch==2.1.0 
torchvision==0.16.0+das1.1.git7d45932.abi1.dtk2404.torch2.1 mmcv==2.0.1+das1.1.gite58da25.abi1.dtk2404.torch2.1.0
```

Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应

2、安装mmpretrain仓库源码

```shell
cd mmpretrain-mmcv
pip install -e .
```

3、其它非特殊库参照requirements.txt安装

```shell
pip install -r requirements.txt
```



## 数据集

### ImageNet

在本项目中可以使用ImageNet数据集。下载ImageNet数据集：https://image-net.org/

可于SCNet快速下载[imagenet-2012](http://113.200.138.88:18080/aidatasets/project-dependency/imagenet-2012)

下载其中的ILSVRC2012_img_train.tar和ILSVRC2012_img_val.tar并按照以下方式解包

```bash
cd mmpretrain-mmcv/data/imagenet
mkdir train && cd train
tar -xvf ILSVRC2012_img_train.tar
```

解包后是1000个tar文件，每个tar对应了一个类别，解包至对应文件夹

```bash
for tarfile in *.tar; do
    dirname="${tarfile%.tar}"
    mkdir "$dirname"
    tar -xvf "$tarfile" -C "$dirname"
done
```

目录结构如下

```
data
└── imagenet
    ├── train
    │   ├── n01440764
    │   │   ├── n01440764_10026.JPEG
    │   │   ├── n01440764_10027.JPEG
    ├──val
    │   ├── n01440764 
    │   │   ├── ILSVRC2012_val_00000293.JPEG
```



### tiny-imagenet-200

由于ImageNet完整数据集较大，可以使用[tiny-imagenet-200](http://cs231n.stanford.edu/tiny-imagenet-200.zip)进行测试，此时需要对配置脚本进行一些修改：

- dataset配置文件(configs/\_\_base\_\_/datasets/xxx.py)中，需要对以下字段进行修改
  
  ```python
  # dataset settings
  dataset_type = 'CustomDataset'  # 修改为CustomDataset
  data_preprocessor = dict(
      num_classes=200,  # 修改类别为200
      ...
  )
  ...
  train_dataloader = dict(
      batch_size=32,
      num_workers=5,
      dataset=dict(
          type=dataset_type,
          data_root='data/imagenet',
          data_prefix='train',  # 改为data_prefix='train'，val_dataloader中同理
          pipeline=train_pipeline),
      sampler=dict(type='DefaultSampler', shuffle=True),
  )
  ```

- model配置文件(configs/\_\_base\_\_/models/xxx.py)中，同样需要将类别相关的值设置为200。
  
  ```python
  # model settings
  model = dict(
      type='ImageClassifier',
      ...
      head=dict(
          type='LinearClsHead',
          num_classes=200,  # 将类别数改为200
          ...
      ))
  ```

mmpretrain-mmcv中提供了使用tiny-imagenet-200进行训练的若干配置脚本，可参考进行设置。

将训练数据集解压后放置于mmpretrain-mmcv/data/，对于tiny-imagenet，目录结构如下：

```
data
└── imagenet
    ├── test/
    ├── train/
    ├── val/
    ├── wnids.txt
    └── words.txt

```

## 启动训练

```shell
bash tools/dist_train.sh <配置文件脚本> <训练用卡数>
```

如遇端口占用问题，可在tools/dist_train.sh修改端口



更多的配置文件在configs目录下，可根据需要进行修改，继承的基础配置在configs/\_base\_/下，具体地

- configs/\_base\_/datasets/xxx.py 数据集相关配置

- configs/\_base\_/models/xxx.py 模型相关配置

- configs/\_base\_/shedules/xxx.py 训练过程相关配置
  
  
