model = dict(
    type='MinkUNet',
    data_preprocessor=dict(
        type='Det3DDataPreprocessor',
        voxel=True,
        voxel_type='minkunet',
        voxel_layer=dict(
            max_num_points=-1,
            point_cloud_range=[-100, -100, -20, 100, 100, 20],
            voxel_size=[0.05, 0.05, 0.05],
            max_voxels=(-1, -1)),
    ),
    backbone=dict(
        type='MinkUNetBackbone',
        in_channels=4,
        base_channels=32,
        encoder_channels=[32, 64, 128, 256],
        decoder_channels=[256, 128, 96, 96],
        num_stages=4,
        init_cfg=None),
    decode_head=dict(
        type='MinkUNetHead',
        channels=96,
        num_classes=19,
        dropout_ratio=0,
        loss_decode=dict(type='mmdet.CrossEntropyLoss', avg_non_ignore=True),
        ignore_index=19),
    train_cfg=dict(),
    test_cfg=dict())
