# <div align="center"><strong>MMDetection3D</strong></div>
## 简介
MMDetection3D 是一个基于 PyTorch 的目标检测开源工具箱, 下一代面向3D检测的平台. 它是 OpenMMlab 项目的一部分，这个项目由香港中文大学多媒体实验室和商汤科技联合发起.
## 安装
  源码编译安装，该方式需要安装torch及fastpt工具包；注意使用fastpt包进行源码编译安装时，要严格匹配fastpt、torch、dtk之间的版本号，例如基于dtk2504编译，则fastpt、torch都必须是dtk2504的包，其中fastpt与torch对应的版本号关系为
|   | fastpt版本 | torch版本    | DTK版本 | 
| - | -------- | ------- | ------------ | 
| 1 | 2.0.1+das.dtk2504   | v2.4.1 |  dtk2504| 
| 1 | 2.1.0+das.dtk2504   | v2.5.1 |  dtk2504| 
| 1 | 2.0.1+das.dtk25041   | v2.4.1 |  dtk25041| 
| 1 | 2.1.0+das.dtk25041   | v2.5.1 |  dtk25041| 

### 编译流程
  ```
  pip3 install -r requirements.txt
  pip3 install fastpt-2.0.1+das.dtk2504-py3-none-any.whl #以torch2.4.1，dtk2504为例
  git clone https://developer.sourcefind.cn/codes/OpenDAS/mmdetection3d.git
  cd mmdetection3d
  git checkout v1.4.0-fastpt #切换到相应分支
  source  /usr/local/bin/fastpt -c
  python3 setup.py bdist_wheel
  ```
## 验证安装
```
pip3 list | grep unicore
python3
import mmdet3d
mmdet3d.__version__
#返回版本号
```
## 测试
```
source  /usr/local/bin/fastpt -e
cd testing
pytest vs

```
