# <div align="center"><strong>MMCV</strong></div>
## 简介
MMCV是计算机视觉研究的基础库，主要提供以下功能：图像处理、图像和标注结果可视化、图像转换、多种CNN网络结构、高质量实现的常见CUDA算子。MMCV官方github地址:[https://github.com/open-mmlab/mmcv](https://github.com/open-mmlab/mmcv)

## 安装

### 使用pip方式安装
mmcv whl包下载目录：[https://cancon.hpccube.com:65024/4/main/mmcv/dtk23.04](https://cancon.hpccube.com:65024/4/main/mmcv/dtk23.04)
选择对应的pytorch版本和python版本下载对应mmcv的whl包
```shell
pip install mmcv* (下载的mmcv的whl包)
```
### 使用源码编译方式安装

#### 编译环境准备
提供2种环境准备方式：

1. 基于光源pytorch基础镜像环境：镜像下载地址：[https://sourcefind.cn/#/image/dcu/pytorch](https://sourcefind.cn/#/image/dcu/pytorch)根据pytorch、python、dtk及系统下载对应的镜像版本。

2. 基于现有python环境：安装pytorch，pytorch whl包下载目录：[https://cancon.hpccube.com:65024/4/main/pytorch/dtk23.04](https://cancon.hpccube.com:65024/4/main/pytorch/dtk23.04)，根据python、dtk版本,下载对应pytorch的whl包。安装命令如下：
```shell
pip install torch* (下载的torch的whl包)
pip install setuptools=59.5.0 wheel
```

#### 源码编译安装
- 代码下载
```shell
git clone https://developer.hpccube.com/codes/aicomponent/mmcv # 根据编译需要切换分支
```
- 提供2种源码编译方式（进入mmcv目录）：
```
1. 编译whl包并安装
MMCV_WITH_OPS=1 ROCM_HOME=${ROCM_PATH} python3 setup.py -v bdist_wheel
pip install dist/mmcv*

2. 源码编译安装
MMCV_WITH_OPS=1 ROCM_HOME=${ROCM_PATH} python3 setup.py install
```

## 版本号查询
- python -c "import mmcv; mmcv.\_\_version__"，版本号与官方版本同步，查询该软件的版本号，例如2.0.0；

## Known Issue
- 无

## Note
+ 若使用pip install下载安装过慢，可添加pypi清华源：-i https://pypi.tuna.tsinghua.edu.cn/simple/
+ ROCM_PATH为dtk的路径，默认为/opt/dtk

## 其他参考
- [README_ORIGIN](README_ORIGIN.md)
- [README_zh-CN](README_zh-CN.md)
