<div align="center">
  <img src="https://raw.githubusercontent.com/open-mmlab/mmcv/master/docs/en/mmcv-logo.png" width="300"/>
</div>

## 安装
### mmcv支持
+ python3.7
+ python3.8
+ python3.9

### 使用pip安装
mmcv whl包下载目录：[https://cancon.hpccube.com:65024/4/main/mmcv/dtk23.04](https://cancon.hpccube.com:65024/4/main/mmcv/dtk23.04)
选择对应的pytorch版本和python版本下载对应mmcv的whl包
```shell
pip install mmcv* (下载的mmcv的whl包)
```
### 使用源码安装

#### 编译环境准备
pytorch whl包下载目录：[https://cancon.hpccube.com:65024/4/main/pytorch/dtk23.04](https://cancon.hpccube.com:65024/4/main/pytorch/dtk23.04)
根据python版本,下载对应pytorch的whl包
```shell
pip install torch* (下载的torch的whl包)
pip install setuptools=59.5.0 wheel
```

#### 编译安装
```shell
git clone https://developer.hpccube.com/codes/aicomponent/mmcv # 根据编译需要切换分支
cd mmcv

1、 编译whl包并安装
MMCV_WITH_OPS=1 ROCM_HOME=${ROCM_PATH} python3 setup.py -v bdist_wheel
pip install dist/mmcv*

2、 直接编译安装
MMCV_WITH_OPS=1 ROCM_HOME=${ROCM_PATH} python3 setup.py install
```
## 安装包命名
例：mmcv-2.0.0+gitc7118e5.abi0.dtk2304.torch1.13-cp37-cp37m-manylinux2014_x86_64.whl
- mmcv: 软件名称；
- 2.0.0: 软件版本号；
- gitc7118e5: git号；
- abi0: 对应centos和rocky多系统的标识，取值为abi0（centos7），abi1(rocky8)，可使用命令行动态查询获取辅助判断（echo '#include <string>' | gcc -x c++ -E -dM - | fgrep _GLIBCXX_USE_CXX11_ABI）;
- dtk2304: 对应dtk大版本号，命令行动态查询取值（/opt/dtk-23.04/.info/rocm_version）；
- torch1.13: 对应构建的torch版本号，命令行动态查询取值（torch.\_\_version__）;
- cp37-cp37m: 对应python版本号；
- manylinux2014_x86_64: 系统架构;

## 版本号查询
- mmcv.\_\_version__：与官方版本同步，查询该软件的版本号，例如2.0.0；

## Note
+ 若使用 pip install 下载安装过慢，可添加源：-i https://pypi.tuna.tsinghua.edu.cn/simple/
+ ROCM_PATH为dtk的路径，默认为/opt/dtkxxx

## 其他参考
- [README_ORIGIN](README_ORIGIN.md)
- [README_zh-CN](README_zh-CN.md)