# <div align="center"><strong>MMCV</strong></div>
## 简介
MMCV是计算机视觉研究的基础库，主要提供以下功能：图像处理、图像和标注结果可视化、图像转换、多种CNN网络结构、高质量实现的常见CUDA算子。DAS软件栈中的MMCV版本，不仅保证了组件核心功能在DCU加速卡的可用性,还针对DCU特有的硬件架构进行了深度定制优化。这使得开发者能够以极低的成本，轻松实现应用程序在DCU加速卡上的快速迁移和性能提升。

## 安装
组件支持
+ Python 3.7、3.8、3.9、3.10

### 1、使用pip方式安装
mmcv whl包下载目录：[http://10.6.10.68:8000/debug/mmcv/dtk-24.04.1/](http://10.6.10.68:8000/debug/mmcv/dtk-24.04.1/)，选择对应的pytorch版本和python版本下载对应mmcv的whl包
```shell
pip install mmcv* (下载的mmcv的whl包)
```
### 2、使用源码编译方式安装

#### 编译环境准备
提供基于fastpt不转码编译：

1. 基于光源pytorch基础镜像环境：镜像下载地址：[https://sourcefind.cn/#/image/dcu/pytorch](https://sourcefind.cn/#/image/dcu/pytorch)，根据pytorch、python、dtk及系统下载对应的镜像版本。

2. 基于现有python环境：安装pytorch，fastpt whl包下载目录：[http://10.6.10.68:8000/debug/pytorch/dtk24.04.1/](http://10.6.10.68:8000/debug/pytorch/dtk24.04.1/)，根据python、dtk版本,下载对应pytorch的whl包。安装命令如下：
```shell
pip install torch* (下载的torch的whl包)
pip install fastpt* (下载的fastpt的whl包, 安装顺序， 先安装torch，后安装fastpt)
pip install setuptools==59.5.0 wheel
```

#### 源码编译安装
- 代码下载
```shell
git clone https://developer.hpccube.com/codes/aicomponent/mmcv # 根据编译需要切换分支
```
- 提供2种源码编译方式（进入mmcv目录）：
```
1. 设置不转码编译环境变量
source /opt/dtk/cuda/env.sh
export USE_FASTPT_CUDA=True

2. 编译whl包并安装
MMCV_WITH_OPS=1 python3 setup.py -v bdist_wheel
pip install dist/mmcv*

3. 源码编译安装
MMCV_WITH_OPS=1 python3 setup.py install
```
#### 注意事项
+ 若使用pip install下载安装过慢，可添加pypi清华源：-i https://pypi.tuna.tsinghua.edu.cn/simple/
+ ROCM_PATH为dtk的路径，默认为/opt/dtk

## 验证
- python -c "import mmcv; mmcv.\_\_version__"，版本号与官方版本同步，查询该软件的版本号，例如2.1.0；

## Known Issue
- 无

## 参考资料
- [README_ORIGIN](README_ORIGIN.md)
- [README_zh-CN](README_zh-CN.md)
- [https://github.com/open-mmlab/mmcv](https://github.com/open-mmlab/mmcv)
