# 内容
- [内容](#内容)
- [环境配置](#环境配置)
- [下载词汇文件](#下载词汇文件)
- [下载训练数据](#下载训练数据)
- [训练](#训练)
  - [数据预处理](#数据预处理)
  - [GPT预训练](#gpt预训练)
    - [分布式多卡训练](#分布式多卡训练)
- [GPT文本生成](#gpt文本生成)
- [参考](#参考)

# 环境配置
1. 安装基础依赖包
<pre>
pip install -r requirements.txt
</pre>
2. 安装DCU相关whl包

DCU相关包下载目录：[https://cancon.hpccube.com:65024/4/main](https://cancon.hpccube.com:65024/4/main)

pytorch whl包：pytorch ---> dtk-24.04.1
根据python版本,下载对应pytorch的whl包

<pre>
pip install torch* (下载的torch的whl包)
</pre>
torchvision whl包：vision ---> dtk-24.04.1
根据python版本,下载对应torchvision的whl包

<pre>
pip install torchvision* (下载的torchvision的whl包)
</pre>
apex whl包：apex ---> dtk-24.04.1
根据python版本,下载对应apex的whl包

<pre>
pip install apex* (下载的apex的whl包)
</pre>

若使用 pip install 下载安装过慢，可添加源：-i https://pypi.tuna.tsinghua.edu.cn/simple/

# 预训练
## gpt
### 下载词汇文件

<pre>
wget https://s3.amazonaws.com/models.huggingface.co/bert/gpt2-vocab.json
wget https://s3.amazonaws.com/models.huggingface.co/bert/gpt2-merges.txt
</pre>

### 下载训练数据
使用1GB 79K jsonl数据集
<pre>
wget https://huggingface.co/bigscience/misc-test-data/resolve/main/stas/oscar-1GB.jsonl.xz
xz -d oscar-1GB.jsonl.xz
</pre>
解压后为单个`oscar-1GB.jsonl`文件

### 数据预处理

```shell
python tools/preprocess_data.py \
    --input oscar-1GB.jsonl \ 
    --output-prefix ./dataset/oscar-1GB-gpt \
    --vocab-file gpt2-vocab.json \
    --tokenizer-type GPT2BPETokenizer \
    --merge-file gpt2-merges.txt \
    --append-eod \
    --workers 8

# 参数说明
# --input				输入数据集路径，即oscar-1GB.jsonl.xz解压后的文件路径
# --output-prefix		输出数据路径，处理后会自动加上_text_document后缀
# --vocab-file				下载的gpt2-vocab.json词表文件路径
# --tokenizer-type 	tokenizer类型
# --merge-file		下载的gpt2-merges.txt文件路径		
# --append-eod		添加结束标志符		
# --workers			进程数
```


### GPT预训练
脚本: `GPT_pretrain.sh`

修改数据集与词汇文件路径
```shell
VOCAB_FILE=gpt2-vocab.json
MERGE_FILE=gpt2-merges.txt
DATA_PATH="./dataset/oscar-1GB-gpt_text_document"
```
- 单机多卡训练
  ```shell
  # 修改脚本中的分布式启动参数
  # nproc_per_node表示单节点卡数
  # nnodes表示节点数量
  # node_rank表示当前节点编号
  # master_addr表示主节点地址
  # master_port表示通信端口
  bash GPT_pretraining.sh >& GPT_pretraining.log
  ```
  在`GPT_pretraining.log`中查看训练日志

- 多机多卡训练
  
  设有节点192.168.1.1和192.168.1.2两个节点

  ```shell
  # 节点192.168.1.1执行下行命令:
  bash GPT_pretraining.sh --NNODES 2 --NODE_RANK 0 --MASTER_ADDR 192.168.1.1 >& GPT_pretraining_rank0.log
  # 节点192.168.1.2执行下行命令:
  bash GPT_pretraining.sh --NNODES 2 --NODE_RANK 1 --MASTER_ADDR 192.168.1.1 >& GPT_pretraining_rank1.log
  ```
  在`GPT_pretraining_rank0.log`和`GPT_pretraining_rank1.log`中查看训练日志

## llama
### 下载tokenizer文件

链接: https://www.modelscope.cn/models/shakechen/Llama-2-7b-hf/files
下载其中的tokenizer*文件

### 下载训练数据
使用1GB 79K jsonl数据集
<pre>
wget https://huggingface.co/bigscience/misc-test-data/resolve/main/stas/oscar-1GB.jsonl.xz
xz -d oscar-1GB.jsonl.xz
</pre>
解压后为单个`oscar-1GB.jsonl`文件

### 数据预处理

```shell
python tools/preprocess_data.py \
  --input oscar-1GB.jsonl \
  --output-prefix /datasets/oscar-1GB-llama\
  --tokenizer-type Llama2Tokenizer \
  --tokenizer-model /path/to/llama2_7b_hf/tokenizer.model \
  --workers 16 \
  --append-eod
```

### llama预训练
脚本: `llama_pretrain.sh`

修改数据集与tokenizer路径
```shell
DATA_PATH="/datasets/oscar-1GB-llama_text_document"
--tokenizer-model /path/to/llama2_7b_hf/tokenizer.model
```
- 单机多卡训练
  ```shell
  bash llama_pretraining.sh >& llama_pretraining.log
  ```
  在`llama_pretraining.log`中查看训练日志

- 多机多卡训练
  
  设有节点192.168.1.1和192.168.1.2两个节点

  ```shell
  # 节点192.168.1.1执行下行命令:
  bash llama_pretraining.sh --NNODES 2 --NODE_RANK 0 --MASTER_ADDR 192.168.1.1 >& llama_pretraining_rank0.log
  # 节点192.168.1.2执行下行命令:
  bash llama_pretraining.sh --NNODES 2 --NODE_RANK 1 --MASTER_ADDR 192.168.1.1 >& llama_pretraining_rank1.log
  ```
  在`GPT_pretraining_rank0.log`和`GPT_pretraining_rank1.log`中查看训练日志

# 参考

- [README_ORIGIN](README_ORIGIN.md)
