# 内容
- [内容](#内容)
- [环境配置](#环境配置)
- [下载词汇文件](#下载词汇文件)
- [下载训练数据](#下载训练数据)
- [训练](#训练)
  - [数据预处理](#数据预处理)
  - [GPT预训练](#gpt预训练)
    - [分布式多卡训练](#分布式多卡训练)
- [GPT文本生成](#gpt文本生成)
- [参考](#参考)

# 环境配置
1. 拉取合适镜像
<pre>
docker pull nvcr.io/nvidia/pytorch:24.06-py3
</pre>

2. 创建镜像并进入

<pre>
docker run -it --name xx --gpus all --network=host --ipc=host --privileged -v /path_to_work/:/path_to_work/ --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined nvcr.io/nvidia/pytorch:24.06-py3 /bin/bash
docker exec -it xx bash
</pre>


# 下载词汇文件

<pre>
wget https://s3.amazonaws.com/models.huggingface.co/bert/gpt2-vocab.json
wget https://s3.amazonaws.com/models.huggingface.co/bert/gpt2-merges.txt
</pre>


# 下载训练数据
使用1GB 79K jsonl数据集
<pre>
wget https://huggingface.co/bigscience/misc-test-data/resolve/main/stas/oscar-1GB.jsonl.xz
xz -d oscar-1GB.jsonl.xz
</pre>

# 训练

## 数据预处理

<pre>
python tools/preprocess_data.py \
    --input oscar-1GB.jsonl \ 
    --output-prefix ./dataset/my-gpt2 \
    --vocab-file gpt2-vocab.json \
    --tokenizer-type GPT2BPETokenizer \
    --merge-file gpt2-merges.txt \
    --append-eod \
    --workers 8
</pre>

参数说明
--input				输入数据集路径，即oscar-1GB.jsonl.xz解压后的文件路径
--output-prefix		输出数据路径，处理后会自动加上_text_document后缀
--vocab-file				下载的gpt2-vocab.json词表文件路径
--tokenizer-type 	tokenizer类型
--merge-file		下载的gpt2-merges.txt文件路径		
--append-eod		添加结束标志符		
--workers			进程数

## GPT预训练

### 分布式训练
- 修改DATA_PATH路径

  ```bash
  VOCAB_FILE=gpt2-vocab.json
  MERGE_FILE=gpt2-merges.txt
  DATA_PATH="./dataset/my-gpt2_text_document"
  ```

- 执行多卡训练

  ```
  #np为起的进程数，np\hostfile均需按实际填写
  mpirun -np 4 --hostfile hostfile single.sh localhost（基于单节点四卡）
  ```

# 参考

- [README_ORIGIN](README_ORIGIN.md)
