// Copyright (c) 2020, NVIDIA CORPORATION. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  * Neither the name of NVIDIA CORPORATION nor the names of its
//    contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#pragma once

#include "tritonserver_apis.h"

namespace triton { namespace core {

//
// Implementation for TRITONSERVER_ResponseAllocator.
//
class ResponseAllocator {
 public:
  explicit ResponseAllocator(
      TRITONSERVER_ResponseAllocatorAllocFn_t alloc_fn,
      TRITONSERVER_ResponseAllocatorReleaseFn_t release_fn,
      TRITONSERVER_ResponseAllocatorStartFn_t start_fn)
      : alloc_fn_(alloc_fn), buffer_attributes_fn_(nullptr), query_fn_(nullptr),
        release_fn_(release_fn), start_fn_(start_fn)
  {
  }

  void SetQueryFunction(TRITONSERVER_ResponseAllocatorQueryFn_t query_fn)
  {
    query_fn_ = query_fn;
  }

  void SetBufferAttributesFunction(
      TRITONSERVER_ResponseAllocatorBufferAttributesFn_t buffer_attributes_fn)
  {
    buffer_attributes_fn_ = buffer_attributes_fn;
  }

  TRITONSERVER_ResponseAllocatorAllocFn_t AllocFn() const { return alloc_fn_; }
  TRITONSERVER_ResponseAllocatorBufferAttributesFn_t BufferAttributesFn() const
  {
    return buffer_attributes_fn_;
  }
  TRITONSERVER_ResponseAllocatorQueryFn_t QueryFn() const { return query_fn_; }
  TRITONSERVER_ResponseAllocatorReleaseFn_t ReleaseFn() const
  {
    return release_fn_;
  }
  TRITONSERVER_ResponseAllocatorStartFn_t StartFn() const { return start_fn_; }

 private:
  TRITONSERVER_ResponseAllocatorAllocFn_t alloc_fn_;
  TRITONSERVER_ResponseAllocatorBufferAttributesFn_t buffer_attributes_fn_;
  TRITONSERVER_ResponseAllocatorQueryFn_t query_fn_;
  TRITONSERVER_ResponseAllocatorReleaseFn_t release_fn_;
  TRITONSERVER_ResponseAllocatorStartFn_t start_fn_;
};

}}  // namespace triton::core
