# <div align="center"><strong>LMdeploy</strong></div>
## 简介
LMDeploy 由 [MMDeploy](https://github.com/open-mmlab/mmdeploy) 和 [MMRazor](https://github.com/open-mmlab/mmrazor) 团队联合开发，是涵盖了 LLM 任务的全套轻量化、部署和服务解决方案。
这个强大的工具箱提供以下核心功能：

- **高效推理引擎 TurboMind**：基于 [FasterTransformer](https://github.com/NVIDIA/FasterTransformer)，我们实现了高效推理引擎 TurboMind，支持 InternLM、LLaMA、vicuna等模型在 NVIDIA GPU 上的推理。

- **交互推理方式**：通过缓存多轮对话过程中 attention 的 k/v，记住对话历史，从而避免重复处理历史会话。

- **多 GPU 部署和量化**：我们提供了全面的模型部署和量化支持，已在不同规模上完成验证。

- **persistent batch 推理**：进一步优化模型执行效率。

persistent batch 推理：进一步优化模型执行效率。
LMdeploy官方github地址:[https://github.com/InternLM/lmdeploy](https://github.com/InternLM/lmdeploy)
## 支持模型
|     模型     | 模型并行 | FP16 |
| :----------: | :------: | :--: |
|    Llama     |   Yes    | Yes  |
|    Llama2    |   Yes    | Yes  |
| InternLM-7B  |   Yes    | Yes  |
| InternLM-20B |   Yes    | Yes  |
|   QWen-7B    |   Yes    | Yes  |
|   QWen-14B   |   Yes    | Yes  |
|   QWen-72B   |   Yes    | Yes  |
| Baichuan-7B  |   Yes    | Yes  |
| Baichuan2-7B |   Yes    | Yes  |
|    wizardlM  |   Yes    | Yes  |
|    vicuna    |   Yes    | Yes  |
|     puyu     |   Yes    | Yes  |
|   codellama  |   Yes    | Yes  |
|    solar     |   Yes    | Yes  |
|   ultracm    |   Yes    | Yes  |
|   ultralm    |   Yes    | Yes  |
|     yi       |   Yes    | Yes  |


## 安装

### 使用源码编译方式安装

#### 编译环境准备
下载光源的镜像，起dcoker(镜像已安装lmdeploy)
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310

# <Image ID>用上面拉取docker镜像的ID替换
# <Host Path>主机端路径
# <Container Path>容器映射路径
docker run -it --name baichuan --shm-size=1024G -v /opt/hyhal:/opt/hyhal:ro --device=/dev/kfd --device=/dev/dri/ --cap-add=SYS_PTRACE --security-opt seccomp=unconfined --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v <Host Path>:<Container Path> <Image ID> /bin/bash

#安装gpufusion
#网页侧下载安装包：https://forum.hpccube.com/thread/483
wget https://forum.hpccube.com/download?url=https://forum.hpccube.com/api/v3/attachment.download?sign=3b3a3d6f1a0d840c57857e63f1ffd231&attachmentsId=511&threadId=483&threadId=483
unzip gpufusion.zip -d /opt/dtk
#激活环境
source /opt/dtk/env.sh
source /opt/dtk/cuda/env.sh

#安装其他环境依赖(若安装过慢，可以添加源:pip3 install xxx -i  https://pypi.tuna.tsinghua.edu.cn/simple/)
#centos7.6环境
pip3 install -r requirements.txt
pip3 install urllib3==1.24
yum install rapidjson

#ubuntu20.04环境
export NCCL_LIB_DIR=/opt/dtk/cuda/lib64
pip3 install -r requirements.txt
pip3 install urllib3==1.24
#apt-get 换源，添加清华源
#添加清华源后更新
#vim /etc/apt/sources.list
#添加清华源如下：
#deb https://mirrors.tuna.tsinghua.edu.cn/ubuntu/ focal main restricted universe multiverse
#deb https://mirrors.tuna.tsinghua.edu.cn/ubuntu/ focal-updates main restricted universe multiverse
#deb https://mirrors.tuna.tsinghua.edu.cn/ubuntu/ focal-backports main restricted universe multiverse
#deb https://mirrors.tuna.tsinghua.edu.cn/ubuntu/ focal-security main restricted universe multiverse
#换源完成后进行更新
sudo apt-get update
apt-get install rapidjson-dev

# 执行nccl环境变量
export NCCL_LAUNCH_MODE=GROUP
```
注：

1、docker启动  -v /opt/hyhal:/opt/hyhal  这个变量不能少                        
2、gpufusion wget指令提供的网址可能会有变化，可以进入提供网页下载对应压缩工具包                 

#### 源码编译安装
- 代码下载
根据不同的需求下载不同的分支
- 提供2种源码编译方式（进入lmdeploy目录）：
```
1. 源码编译安装
mkdir build && cd build
sh ../generate.sh
make -j 32 && make install
#假如环境中存在老版本的lmdeploy，需要使用pip uninstall先将老版本卸载
cd .. && python3 setup.py install

2. 编译成whl包安装
# 安装wheel 
pip3 install wheel 
mkdir build && cd build
sh ../generate.sh
make -j 32 && make install
cd .. && python3 setup.py bdist_wheel
cd dist && pip3 install lmdeploy*
```

## 模型服务

### 模型转换
```bash
# <model_name> 模型的名字 （'llama', 'internlm', 'vicuna', 'wizardlM', 'internlm-chat-7b', 'internlm-chat', 'internlm-chat-7b-8k', 'internlm-chat-20b', 'internlm-20b', 'baichuan-7b', 'baichuan2-7b', 'puyu', 'llama2', 'qwen-7b', 'qwen-14b', 'qwen-72b', 'codellama', 'solar', 'ultralm', 'ultracm', 'yi'）
# <model_path> 模型路径
# <model_format> 模型的格式 （'llama', 'hf'， None。可以不写默认None,代码会根据模型选择格式,一般选择不写）
# <model_format> 保存输出的目标路径（默认./workspace）
# <tp> 用于张量并行的GPU数量应该是2^n

lmdeploy convert ${model_name} ${model_path} --model-format ${model_format} --dst-path ${dst_path} --tp ${tp}
```
### 运行
#### bash界面运行
```bash
# <model_path>:转换后的模型路径
#此处的model_path处可以采用转换后的模型，也可以直接使用未转换的hf模型，但是需要注意假如使用的是转换后的模型，tp要和转模型的tp保持一致
lmdeploy chat turbomind ${model_path} --tp ${tp}    # 输入问题后执行2次回车进行推理 
```
#### web页面方式交互：
```bash
#在bash端运行：
# <server-name> gradio服务器的ip地址
# <server-port> gradio服务器的ip的端口
# <backend> 用于支持推理的后端，可以是pytorch,也可以选择turbomind
# <model-name> 需要推理的模型名，比如：llama-7b, llama-13b, vicuna-7,llama2等
# <tp> 用于张量并行的GPU数量应该是2^n （和模型转换的时候保持一致）
# <model-format> 推理模型格式，有hf,llama,awq选项
# 更多参数使用lmdeploy serve gradio 可以查询

lmdeploy serve gradio ${model_path}  --server-name ${ip} --server-port ${pord}  --backend turbomind  --model-name llama2 --model-format hf --tp ${tp}
```
在网页上输入{ip}:{pord}即可进行对话, **需要保证'{ip}:{pord}'在外部浏览器中的可访问性**

#### 使用api-server
启动server：
```bash
#在bash端运行：
lmdeploy serve api_server ${model_path}  --server-name ${ip} --server-port ${pord}  --backend turbomind  --model-name llama2 --model-format hf --tp ${tp}
```
用户将下面命令输出的 http url 复制到浏览器打开，详细查看所有的 API 及其使用方法。 请一定查看http://{server_ip}:{server_port}！！！ 请一定查看http://{server_ip}:{server_port}！！！ 请一定查看http://{server_ip}:{server_port}！！！ 重要的事情说三遍。

api-server的详细使用可以参照[这里](docs/zh_cn/serving)的文档

codellama模型的部署可以参照[codellama](docs/zh_cn/supported_models/codellama.md)

### AWQ 量化推理
本版本支持量化推理功能，步骤如下：
```bash
#group_size:按照模型量化时候的分组参数，一般为128
#<tp> 用于张量并行的GPU数量应该是2^n 
#<dst-path> 保存模型的目标文件夹
#step1:模型转换：
lmdeploy convert ${model_name} ${model_path} --model_format awq --group-size ${group_size} --tp ${tp} --dst-path ${dst_path}
#step1:模型运行
lmdeploy chat turbomind ${dst_path} --tp ${tp}
```
注意事项：              
1.该版本暂时仅支持tp=1 单卡量化推理，仅支持卡型KM-AI，暂不支持K100/Z100/Z100L；             
2.该版本量化推理功能仅支持先通过convert模型转换为turbomind格式，然后进行推理运行，暂时不知道hf模型直接量化推理；               
3.该版本暂时不支持通过数据集进行量化功能，需要在别处获取量化模型；                       

## result
![qwen推理](docs/dcu/interlm.gif)

### 详细可参考 [docs](./docs/zh_cn/serving.md) 
## 版本号查询
- python -c "import lmdeploy; print(lmdeploy.\_\_version__)"，版本号与官方版本同步，查询该软件的版本号，例如0.2.6；

## Known Issue
- 无

## Note
+ 若使用pip install下载安装过慢，可添加pypi清华源：-i https://pypi.tuna.tsinghua.edu.cn/simple/

## 其他参考
- [README_origin](README_origin.md)
- [README_zh-CN](README_zh-CN.md)
