# <div align="center"><strong>LMdeploy</strong></div>
## 简介
LMDeploy 由 [MMDeploy](https://github.com/open-mmlab/mmdeploy) 和 [MMRazor](https://github.com/open-mmlab/mmrazor) 团队联合开发，是涵盖了 LLM 任务的全套轻量化、部署和服务解决方案。
这个强大的工具箱提供以下核心功能：

- **高效推理引擎 TurboMind**：基于 [FasterTransformer](https://github.com/NVIDIA/FasterTransformer)，我们实现了高效推理引擎 TurboMind，支持 InternLM、LLaMA、vicuna等模型在 NVIDIA GPU 上的推理。

- **交互推理方式**：通过缓存多轮对话过程中 attention 的 k/v，记住对话历史，从而避免重复处理历史会话。

- **多 GPU 部署和量化**：我们提供了全面的模型部署和量化支持，已在不同规模上完成验证。

- **persistent batch 推理**：进一步优化模型执行效率。

persistent batch 推理：进一步优化模型执行效率。
LMdeploy官方github地址:[https://github.com/InternLM/lmdeploy](https://github.com/InternLM/lmdeploy)
## 支持模型
|     模型     | 模型并行 | FP16 |
| :----------: | :------: | :--: |
|    Llama     |   Yes    | Yes  |
|    Llama2    |   Yes    | Yes  |
| InternLM-7B  |   Yes    | Yes  |
| InternLM-20B |   Yes    | Yes  |
|   QWen-7B    |   Yes    | Yes  |
|   QWen-14B   |   Yes    | Yes  |
|   QWen-72B   |   Yes    | Yes  |
| Baichuan-7B  |   Yes    | Yes  |
| Baichuan2-7B |   Yes    | Yes  |
|    wizardlM  |   Yes    | Yes  |
|    vicuna    |   Yes    | Yes  |
|     puyu     |   Yes    | Yes  |
|   codellama  |   Yes    | Yes  |
|    solar     |   Yes    | Yes  |
|   ultracm    |   Yes    | Yes  |
|   ultralm    |   Yes    | Yes  |
|     yi       |   Yes    | Yes  |


## 安装

### 使用源码编译方式安装

#### 编译环境准备
下载光源的镜像，起dcoker (镜像已安装lmdeploy)
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:lmdeploy1.0-dtk23.10-torch1.13-py38-latest

# <Image ID>用上面拉取docker镜像的ID替换
# <Host Path>主机端路径
# <Container Path>容器映射路径
docker run -it --name baichuan --shm-size=1024G -v /opt/hyhal:/opt/hyhal --device=/dev/kfd --device=/dev/dri/ --cap-add=SYS_PTRACE --security-opt seccomp=unconfined --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v <Host Path>:<Container Path> <Image ID> /bin/bash
```
注：

1、docker启动  -v /opt/hyhal:/opt/hyhal  这个变量不能少

2、要是非光源提供镜像，配置环境：(若安装过慢，可以添加源:pip3 install xxx -i  https://pypi.tuna.tsinghua.edu.cn/simple/)
```
#centos7.6环境
pip3 install -r requirements.txt
pip3 install urllib3==1.24
yum install rapidjson

#ubuntu20.04环境
export NCCL_LIB_DIR=/opt/dtk/cuda/lib64
pip3 install -r requirements.txt
pip3 install urllib3==1.24
#apt-get 换源，添加清华源
sudo apt-get update
apt-get install rapidjson-dev

# 执行nccl环境变量
export NCCL_LAUNCH_MODE=GROUP
```

#### 源码编译安装
- 代码下载
根据不同的需求下载不同的分支
- 提供2种源码编译方式（进入lmdeploy目录）：
```
1. 源码编译安装
mkdir build && cd build
sh ../generate.sh
make -j 32 && make install
cd .. && python3 setup.py install

2. 编译成whl包安装
# 安装wheel 
pip3 install wheel 
mkdir build && cd build
sh ../generate.sh
make -j 32 && make install
cd .. && python3 setup.py bdist_wheel
cd dist && pip3 install lmdeploy*
```

## 模型服务

### 模型转换
```
# <model_name> 模型的名字 （'llama', 'internlm', 'vicuna', 'wizardlM', 'internlm-chat-7b', 'internlm-chat', 'internlm-chat-7b-8k', 'internlm-chat-20b', 'internlm-20b', 'baichuan-7b', 'baichuan2-7b', 'puyu', 'llama2', 'qwen-7b', 'qwen-14b', 'qwen-72b', 'codellama', 'solar', 'ultralm', 'ultracm', 'yi'）
# <model_path> 模型路径
# <model_format> 模型的格式 （'llama', 'hf'， None。可以不写默认None,代码会根据模型选择格式）
# <tokenizer_path> tokenizer模型的路径（默认None,会去model_path里面找对应的其他模型：'tokenizer.model'，千问：'qwen.tiktoken'）
# <model_format> 保存输出的目标路径（默认./workspace）
# <tp> 用于张量并行的GPU数量应该是2^n

lmdeploy convert ${model_name} ${model_path} --model_format ${model_format} --tokenizer_path ${tokenizer_path} --dst_path ${dst_path} --tp ${tp}
```
### 运行
#### bash界面运行
```
# <model_path>:转换后的模型路径
lmdeploy chat turbomind --model_path ${model_path} --tp ${tp}     # tp要和转模型的tp保持一直 # 输入问题后执行2次回车进行推理 
```
#### web页面方式交互：
```
在bash端运行：
# <model_path_or_server> 部署模型的路径或tritonserver URL或restful api URL。前者用于与gradio直接运行服务。后者用于默认情况下使用tritonserver运行。如果输入URL是restful api。请启用另一个标志“restful_api”。
# <server_name> gradio服务器的ip地址
# <server_port> gradio服务器的ip的端口
# <batch_size> 于直接运行Turbomind的batch大小 （默认32）
# <tp> 用于张量并行的GPU数量应该是2^n （和模型转换的时候保持一致）
# <restful_api> modelpath_or_server的标志（默认是False）

lmdeploy serve gradio --model_path_or_server ${model_path_or_server} --server_name ${ip} --server_port ${pord} --batch_size 32 --tp ${tp}
```
在网页上输入{ip}:{pord}即可进行对话, **需要保证'{ip}:{pord}'在外部浏览器中的可访问性**

#### 使用api-server
启动server：
```
在bash端运行：
# --instance_num: turbomind推理实例的个数。模型支持的并发数 默认32
lmdeploy serve api_server ${model_path} --server_name ${server_ip} --server_port ${server_port} --instance_num ${instance_num} --tp ${tp}
```
用户将下面命令输出的 http url 复制到浏览器打开，详细查看所有的 API 及其使用方法。 请一定查看http://{server_ip}:{server_port}！！！ 请一定查看http://{server_ip}:{server_port}！！！ 请一定查看http://{server_ip}:{server_port}！！！ 重要的事情说三遍。

CLI client
restful api 服务可以通过客户端测试，例如
```
# restful_api_url is what printed in api_server.py, e.g. http://localhost:23333
lmdeploy serve api_client api_server_url
```
webui
也可以直接用 webui 测试使用 restful-api。
```
# api_server_url 就是 api_server 产生的，比如 http://localhost:23333
# server_name 和 server_port 是用来提供 gradio ui 访问服务的
# 例子: lmdeploy serve gradio http://localhost:23333 --server_name localhost --server_port 6006
lmdeploy serve gradio api_server_url --server_name ${gradio_ui_ip} --server_port ${gradio_ui_port}
```
api-server的详细使用可以参照[这里](docs/zh_cn/restful_api.md)的文档

codellama模型的部署可以参照[codellama](docs/zh_cn/supported_models/codellama.md)

### AWQ 量化推理
本版本支持量化推理功能，步骤如下：
```bash
#step1:模型转换：
lmdeploy convert ${model_name} ${model_path} --model_format awq --group-size ${group_size} --tp ${tp}
#step1:模型运行
lmdeploy chat turbomind ./workspace --tp ${tp}
```
注意事项：              
1.该版本暂时仅支持tp=1 单卡量化推理，仅支持卡型KM-AI，暂不支持K100/Z100/Z100L；             
2.该版本量化推理功能仅支持先通过convert模型转换为turbomind格式，然后进行推理运行，暂时不知道hf模型直接量化推理；               
3.该版本暂时不支持通过数据集进行量化功能，需要在别处获取量化模型；                       

## result
![qwen推理](docs/dcu/interlm.gif)

### 详细可参考 [docs](./docs/zh_cn/serving.md) 
## 版本号查询
- python -c "import lmdeploy; lmdeploy.\_\_version__"，版本号与官方版本同步，查询该软件的版本号，例如0.1.0；

## Known Issue
- 无

## Note
+ 若使用pip install下载安装过慢，可添加pypi清华源：-i https://pypi.tuna.tsinghua.edu.cn/simple/

## 其他参考
- [README_origin](README_origin.md)
- [README_zh-CN](README_zh-CN.md)
