# 					 				   llama.cpp

![cover](imgs/cover.png)

## 简介

**项目目标**

*llama.cpp*主要目标是在最小化设置和硬件上实现大规模语言模型（LLM）的推理，并在本地和云端都能达到最先进的性能.

**技术特点**

- **无依赖的 C/C++ 实现**：项目提供了纯 C/C++ 实现，没有外部依赖。
- **DCU 支持**：通过 HIP 和 Moore Threads 支持 DCU。
- **CPU+DCU 混合推理**：支持 CPU+DCU 混合推理，用于部分加速模型，特别是当模型大小超过显存容量时。
- **整数量化**：支持 1.5 位、2 位、3 位、4 位、5 位、6 位和 8 位整数量化，以加快推理速度并减少内存使用。



## 环境准备

**docker**

```shell
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04-py3.10-fixpy

docker run -i -t -d  --device=/dev/kfd --privileged --network=host --device=/dev/dri --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 容器外地址:容器内地址 -v /opt/hyhal:/opt/hyhal:ro  --group-add video --shm-size 16G --name {容器名} {镜像ID}
```

**下载源码**

```bash
git clone http://developer.sourcefind.cn/codes/OpenDAS/llama.cpp.git -b branch #分支号
```

**安装依赖**

```bash
cd llama.cpp
pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple
```

**编译**

```bash
export LIBRARY_PATH=/opt/dtk/llvm/lib/clang/15.0.0/lib/linux/:$LIBRARY_PATH
sh bianyi.sh
```



## **模型格式转换**

```bash
python convert_hf_to_gguf.py  /path/to/model    #同目录下生成model.gguf
```



## **运行**

```bash
cd build/bin

#方式一 命令行界面：
./llama-cli -m /path/to/model.gguf -ngl 9999 -fa -co -p "You are a helpful assistant" -cnv

#方式二 server：
./llama-server -m /path/to/model.gguf -ngl 9999 -fa --port 8080  
```



## **性能测试**

```bash
./llama-batched-bench -m /path/to/model.gguf -pps -c 0 -ngl 9999 -npp 2 -ntg 2000 -npl 1 -fa
```

> [!NOTE]
>
> 参数含义可--help查看



**参考资料**

[https://github.com/ggerganov/llama.cpp/tree/b4160?tab=readme-ov-file](/path/to/model.gguf)