# <div align="center"><strong>LLaMA Factory</strong></div>
## 简介
LLaMA Factory是一个大语言模型训练和推理的框架，支持了魔搭社区（ModelScope）的模型和数据集资源。它允许用户通过内置的Web UI灵活定制100多个LLMs的微调，而无需编写代码。

## 暂不支持的官方功能


## 支持模型结构列表
| 模型名                                                       | 模型大小                          | Template  |
| ------------------------------------------------------------ | -------------------------------- | --------- |
| [Baichuan 2](https://huggingface.co/baichuan-inc)            | 7B/13B                           | baichuan2 |
| [Llama 2](https://huggingface.co/meta-llama)                 | 7B/13B/70B                       | llama2    |
| [Llama 3/Llama 3.1](https://huggingface.co/meta-llama)       | 8B/70B                           | llama3    |
| [Qwen1.5 (Code/MoE)](https://huggingface.co/Qwen)        | 0.5B/1.8B/4B/7B/14B/32B/72B | qwen      |
| [XVERSE](https://hf-mirror.com/xverse)                       | 7B                               | xverse   |

持续更新中...

> 对于所有“基座”（Base）模型，`template` 参数可以是 `default`, `alpaca`, `vicuna` 等任意值。但“对话”（Instruct/Chat）模型请务必使用**对应的模板**。
>
> 请务必在训练和推理时采用**完全一致**的模板。

> **[!NOTE]** `Baichuan 2` 需要卸载掉环境中的xformers库，当前仅支持Lora方式训练。

您也可以在 [template.py](src/llamafactory/data/template.py) 中添加自己的对话模板。

## 使用源码编译方式安装
### 环境准备
-v 路径、docker_name和imageID根据实际情况修改
####  Docker（方法一）
基于光源pytorch2.1.0基础镜像环境：镜像下载地址：[https://sourcefind.cn/#/image/dcu/pytorch](https://sourcefind.cn/#/image/dcu/pytorch)，根据pytorch2.1.0、python、dtk及系统下载对应的镜像版本。

```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=80G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
```

#### Dockerfile（方法二）
```bash
docker build --no-cache -t llama-factory:latest .
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=80G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
```

#### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```bash
DTK驱动: dtk24.04
python: python3.10
torch: 2.1.0
bitsandbytes: 0.42.0

```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

### 源码编译安装
> [!TIP]
> 遇到包冲突时，可使用 `pip install --no-deps -e .` 解决。

```bash
git clone -b v0.6.3 http://developer.hpccube.com/codes/OpenDAS/llama-factory.git
cd /your_code_path/llama_factory
pip install -e .[metrics]

# pdsh安装，deepspeed多机需要，若已安装，可忽略
cd ../
#下载解压
wget https://storage.googleapis.com/google-code-archive-downloads/v2/code.google.com/pdsh/pdsh-2.29.tar.bz2 && tar -xf pdsh-2.29.tar.bz2
#编译安装
cd pdsh-2.29 && ./configure --with-ssh --enable-static-modules --prefix=/usr/local && make && make install
#测试
pdsh -V
```

## 如何使用
### 数据准备
关于数据集文件的格式，请参考 [data/README_zh.md](data/README_zh.md) 的内容。你可以使用 HuggingFace / ModelScope 上的数据集或加载本地数据集。

> [!NOTE]
> 使用自定义数据集时，请更新 `data/dataset_info.json` 文件。

### 微调
大模型微调示例脚本请参考[这里](./examples/README_zh.md)。

## 参考资料
- [README_origin](README_origin.md)
- [LLaMA-Factory](https://github.com/hiyouga/LLaMA-Factory)
