# 模型转换工具

这是一个功能强大的模型权重转换工具，支持格式转换、量化、LoRA融合等多种功能。


## 使用示例

### 1. 模型量化
#### 1.1 Wan2.2-lightning-I2V-A14B 量化为 INT8
```bash
python tools/convert/converter.py \
    --source /path/to/Wan2.2-I2V-A14B/low_noise_model \
    --output /path/to/Wan2.2-I2V-A14B-INT8/low_noise_model \
    --output_ext .safetensors \
    --output_name Wan2.2-I2V-A14B-INT8 \
    --linear_type int8 \
    --non_linear_dtype torch.bfloat16 \
    --model_type wan_dit \
    --quantized \
    --save_by_block
```
```bash
python tools/convert/converter.py \
    --source /path/to/Wan2.2-I2V-A14B/high_noise_model \
    --output /path/to/Wan2.2-I2V-A14B-INT8/high_noise_model \
    --output_ext .safetensors \
    --output_name wan_int8 \
    --linear_type torch.int8 \
    --non_linear_dtype torch.bfloat16 \
    --model_type wan_dit \
    --quantized \
    --save_by_block
```
**模型量化完之后需要把Wan2.2-I2V-A14B中除了low_noise_model和high_noise_model以外的文件复制一份到Wan2.2-I2V-A14B-INT8**

#### 1.2 Wan2.1-I2V-14B-480P 量化为 INT8
```bash
python tools/convert/converter.py \
    --source /path/to/Wan2.1-I2V-14B-480P \
    --output /path/to/Wan2.1-I2V-14B-480P-INT8 \
    --output_ext .safetensors \
    --output_name wan_int8 \
    --linear_type int8 \
    --non_linear_dtype torch.bfloat16 \
    --model_type wan_dit \
    --quantized \
    --save_by_block
```
**模型量化完之后需要把Wan2.1-I2V-14B-480P中除了.safetensors以外的文件复制一份到Wan2.1-I2V-14B-480-INT8**

#### 1.3 Wan2.2-TI2V-5B 量化为 INT8
```bash
python tools/convert/converter.py \
    --source /path/to/Wan2.2-TI2V-5B \
    --output /path/to/Wan2.2-TI2V-5B-INT8 \
    --output_ext .safetensors \
    --output_name wan_int8 \
    --linear_type int8 \
    --non_linear_dtype torch.bfloat16 \
    --model_type wan_dit \
    --quantized \
    --save_by_block
```
**模型量化完之后需要把Wan2.2-TI2V-5B中除了.safetensors以外的文件复制一份到Wan2.2-TI2V-5B-INT8**


### 2. LoRA 融合
#### 2.1 融合单个 LoRA
```bash
python tools/convert/converter.py \
    --source /path/to/base_model/ \
    --output /path/to/output \
    --output_ext .safetensors \
    --output_name merged_model \
    --model_type wan_dit \
    --lora_path /path/to/lora.safetensors \
    --lora_strength 1.0 \
    --single_file
```

#### 2.2 融合多个 LoRA
```bash
python tools/convert/converter.py \
    --source /path/to/base_model/ \
    --output /path/to/output \
    --output_ext .safetensors \
    --output_name merged_model \
    --model_type wan_dit \
    --lora_path /path/to/lora1.safetensors /path/to/lora2.safetensors \
    --lora_strength 1.0 0.8 \
    --single_file
```

## 核心参数说明
### 基础参数
- `-s, --source`: 输入路径（文件或目录）
- `-o, --output`: 输出目录路径
- `-o_e, --output_ext`: 输出格式，可选 `.pth` 或 `.safetensors`（默认）
- `-o_n, --output_name`: 输出文件名（默认: `converted`）
- `-t, --model_type`: 模型类型（默认: `wan_dit`）

### 量化参数
- `--quantized`: 启用量化
- `--bits`: 量化位宽，当前仅支持 8 位
- `--linear_type`: 线性层量化类型
  - `int8`: INT8 量化
  - `float8_e4m3fn`: FP8 量化
- `--non_linear_dtype`: 非线性层数据类型
  - `torch.bfloat16`: BF16
  - `torch.float16`: FP16
  - `torch.float32`: FP32（默认）
- `--device`: 量化使用的设备，可选 `cpu` 或 `cuda`（默认）
- `--comfyui_mode`: ComfyUI 兼容模式
- `--full_quantized`: 全量化模式（ComfyUI 模式下有效）

### LoRA 参数
- `--lora_path`: LoRA 文件路径，支持多个（用空格分隔）
- `--lora_strength`: LoRA 强度系数，支持多个（默认: 1.0）
- `--alpha`: LoRA alpha 参数，支持多个
- `--lora_key_convert`: LoRA 键转换模式
  - `auto`: 自动检测（默认）
  - `same`: 使用原始键名
  - `convert`: 应用与模型相同的转换

### 保存参数
- `--single_file`: 保存为单个文件（注意: 大模型会消耗大量内存）
- `-b, --save_by_block`: 按块保存（推荐用于 backward 转换）
- `-c, --chunk-size`: 分块大小（默认: 100，0 表示不分块）
- `--copy_no_weight_files`: 复制源目录中的非权重文件

### 性能参数
- `--parallel`: 启用并行处理（默认: True）
- `--no-parallel`: 禁用并行处理
