--------------------------------------------------------------------------------

## Lietorch简介

Faiss 是一个用于高效相似性搜索和密集向量聚类的库。它提供了在各种规模的向量集合中进行搜索的算法，包括那些可能无法完全适应 RAM 的大型集合。除了搜索功能，Faiss 还包含用于评估和参数调优的支持代码

## 版本约束

1. 暂不支持的官方版本或功能

   **更高版本**：暂不支持lietorch0.2以上版本

2. lietorch软件版本配套关系

   | lietorch版本 | DCU适配版lietorch软件包版本                 | DCU加速卡型号              | DTK版本 |
   | ----------- | ------------------------------------------ | -------------------------- | ------- |
   | o.2       | 0.2+das.dtk24042                         | Z100、Z100L、K100、K100_AI | 24.04.2 |
   
## 前置条件

使用 DAS PyTorch需要参考[《DCU新手入门教程》](https://developer.hpccube.com/gitbook/dcu_tutorial/index.html)在主机系统安装以下组件:

- DCU驱动程序
- DTK
- Docker引擎

## 安装
组件支持
+ Python 3.7、3.8、3.9、3.10

### 使用源码编译方式安装
基于光源pytorch基础镜像环境：镜像下载地址：[https://sourcefind.cn/#/image/dcu/pytorch](https://sourcefind.cn/#/image/dcu/pytorch)，根据pytorch、python、dtk及系统下载对应的镜像版本。
#### 源码编译安装
- 代码下载
```shell
git clonehttps://developer.sourcefind.cn/codes/OpenDAS/lietorch.git # 根据编译需要切换分支
```
- 提供2种源码编译方式（进入faiss目录）：
  
```
1. 编译whl包并安装
pip3 install wheel 
pip3 install pytest  
cd lietorch
python3 setup.py bdist_wheel
cd dist  
pip3 install lietorch-* --no-deps  --force
```

## 验证

验证安装:__dcu_version__会返回对应版本的dtk版本号

```
python3
Python 3.10.12 (main, May 26 2024, 00:14:02) [GCC 9.4.0] on linux
Type "help", "copyright", "credits" or "license" for more information.
>>> import lietorch
>>> lietorch.__version__
'0.2'
>>> lietorch.__dcu_version__
'0.2+das.dtk2404'
>>>
```

## 单测

```
sh run_tests.sh
```

## Known Issue
- 无
