# <div align="center"><strong>Lietorch</strong></div>
## 简介
LieTorch 库将 PyTorch 扩展应用于三维变换群。就像 torch.Tensor 是一个由标量元素构成的多维矩阵一样，lietorch.SE3 是一个由 SE3 元素构成的多维矩阵。我们支持常见的张量操作，如索引、重塑和广播。群操作可以组合到计算图中，并且会在每个元素的切空间中自动进行反向传播

## 安装
组件支持组合

   | PyTorch版本 | fastpt版本  |Lietorch版本      | DTK版本                  | Python版本       | 推荐编译方式 |
   | ----------- | ----------- | ----------- | ------------------------ | -----------------| ------------ |
   | 2.5.1       | 2.1.0       |0.3        | >= 25.04                 | 3.8、3.10、3.11  | fastpt不转码 |
   | 2.4.1       | 2.0.1       |0.3        | >= 25.04                 | 3.8、3.10、3.11  | fastpt不转码 |
   | 其他        | 其他         | 其他        | 其他                     | 3.8、3.10、3.11  | hip转码      |

+ pytorch版本大于2.4.1 && dtk版本大于25.04 推荐使用fastpt不转码编译。

### 1、使用pip方式安装
lietorch whl包下载目录：[光和开发者社区](https://download.sourcefind.cn:65024/4/main)，选择对应的pytorch版本和python版本下载对应lietorch的whl包
```shell
pip install torch* (下载torch的whl包)
pip install fastpt* --no-deps (下载fastpt的whl包)
source  /usr/local/bin/fastpt -E
pip install lietorch* (下载的lietorch的whl包)
```
### 2、使用源码编译方式安装

#### 编译环境准备
提供基于fastpt不转码编译：

1. 基于光源pytorch基础镜像环境：镜像下载地址：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据pytorch、python、dtk及系统下载对应的镜像版本。

2. 基于现有python环境：安装pytorch，fastpt whl包下载目录：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据python、dtk版本,下载对应pytorch的whl包。安装命令如下：
```shell
pip install torch* (下载torch的whl包)
pip install fastpt* --no-deps (下载fastpt的whl包, 安装顺序，先安装torch，后安装fastpt)
pip install pytest
pip install wheel
```

#### 源码编译安装
- 代码下载
```shell
git clone http://developer.sourcefind.cn/codes/OpenDAS/lietorch.git # 根据编译需要切换分支
```
- 提供2种源码编译方式（进入lietorch目录）：
```
1. 设置不转码编译环境变量
source /usr/local/bin/fastpt -C

2. 编译whl包并安装
cp -r eigen-master/* eigen/
python3 setup.py -v bdist_wheel
pip install dist/lietorch* --no-deps

3. 源码编译安装
cp -r eigen-master/* eigen/
python3 setup.py install --no-deps
```
#### 注意事项
+ 若使用pip install下载安装过慢，可添加pypi清华源：-i https://pypi.tuna.tsinghua.edu.cn/simple/
+ ROCM_PATH为dtk的路径，默认为/opt/dtk
+ 在pytorch2.5.1环境下编译需要支持c++17语法，打开setup.py文件，把文件中的 -std=c++14 修改为 -std=c++17

## 验证
```
python3
Python 3.10.12 (main, Feb  4 2025, 14:57:36) [GCC 11.4.0] on linux
Type "help", "copyright", "credits" or "license" for more information.
>>> import lietorch
>>> import lietorch
>>> lietorch.__version__
'0.3'
>>>
```
版本号与官方版本同步，查询该软件的版本号，例如0.3；

## Known Issue
- 无

## 参考资料
- [README_ORIGIN](README_ORIGIN.md)
- [README_zh-CN](README_zh-CN.md)
- [https://github.com/princeton-vl/lietorch](https://github.com/princeton-vl/lietorch)
