/***************************************************************************************************
 * Copyright (c) 2023 - 2025 Hygon Information Technology Co., Ltd. All rights reserved.
 * SPDX-License-Identifier: BSD-3-Clause
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 **************************************************************************************************/
/*! \file
    \brief Tests for device-wide GEMM interface
*/

#include <iostream>

#include "hytlass/hytlass.h"
#include "hute/tensor.hpp"
#include "hute/atom/mma_atom.hpp"

#include "hytlass/numeric_types.h"

#include "hytlass/gemm/gemm.h"
#include "hytlass/gemm/device/gemm_universal_adapter.h"
#include "hytlass/gemm/kernel/gemm_universal.hpp"
#include "hytlass/epilogue/collective/collective_builder.hpp"
#include "hytlass/gemm/collective/collective_builder.hpp"
#include "hytlass/epilogue/collective/default_epilogue.hpp"
#include "hytlass/epilogue/thread/linear_combination.h"

#include "../../common/hytlass_unit_test.h"

#include "gemm_testbed_3x.hpp"

using namespace hute;

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////// TT //////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

TEST(GFX928_Device_Gemm_f16t_f16t_f16n_align4_tensor_op_f32, 128x128x64) {
  using LayoutA = hytlass::layout::RowMajor;
  using LayoutB = hytlass::layout::RowMajor;
  using LayoutC = hytlass::layout::ColumnMajor;

  using CollectiveOp = typename hytlass::gemm::collective::CollectiveBuilder<
      hytlass::arch::Gfx928, hytlass::arch::OpClassTensorOp,
      hytlass::half_t, LayoutA, 4,
      hytlass::half_t, LayoutB, 4,
      float,
      Shape<_128,_128,_64>, Shape<_2,_2,_1>,
      Shape<_32,_32,_16>, Shape<_1,_1,_1>,
      hytlass::gemm::collective::StageCount<2>,
      hytlass::gemm::collective::KernelScheduleAuto
    >::CollectiveOp;

  using CollectiveEpilogue = typename hytlass::epilogue::collective::CollectiveBuilder<
      hytlass::arch::Gfx928, hytlass::arch::OpClassTensorOp,
      Shape<_128,_128,_64>, Shape<_1,_1,_1>,
      hytlass::epilogue::collective::EpilogueTileAuto,
      float, float,
      hytlass::half_t, LayoutC, 4,
      hytlass::half_t, LayoutC, 4,
      hytlass::epilogue::collective::EpilogueScheduleAuto
    >::CollectiveOp;

  using GemmKernel = hytlass::gemm::kernel::GemmUniversal<
      Shape<int,int,int,int>,
      CollectiveOp,
      CollectiveEpilogue
  >;

  using Gemm = hytlass::gemm::device::GemmUniversalAdapter<GemmKernel>;
  EXPECT_TRUE(test::gemm::device::TestAll<Gemm>());
}

///////////////////////////////////////////////////////////////////////////////

TEST(GFX928_Device_Gemm_f16t_f16t_f16n_align2_tensor_op_f32, 128x128x64) {
  using LayoutA = hytlass::layout::RowMajor;
  using LayoutB = hytlass::layout::RowMajor;
  using LayoutC = hytlass::layout::ColumnMajor;

  using CollectiveOp = typename hytlass::gemm::collective::CollectiveBuilder<
      hytlass::arch::Gfx928, hytlass::arch::OpClassTensorOp,
      hytlass::half_t, LayoutA, 2,
      hytlass::half_t, LayoutB, 2,
      float,
      Shape<_128,_128,_64>, Shape<_2,_2,_1>,
      Shape<_32,_32,_16>, Shape<_1,_1,_1>,
      hytlass::gemm::collective::StageCount<2>,
      hytlass::gemm::collective::KernelScheduleAuto
    >::CollectiveOp;

  using CollectiveEpilogue = typename hytlass::epilogue::collective::CollectiveBuilder<
      hytlass::arch::Gfx928, hytlass::arch::OpClassTensorOp,
      Shape<_128,_128,_64>, Shape<_1,_1,_1>,
      hytlass::epilogue::collective::EpilogueTileAuto,
      float, float,
      hytlass::half_t, LayoutC, 2,
      hytlass::half_t, LayoutC, 2,
      hytlass::epilogue::collective::EpilogueScheduleAuto
    >::CollectiveOp;

  using GemmKernel = hytlass::gemm::kernel::GemmUniversal<
      Shape<int,int,int,int>,
      CollectiveOp,
      CollectiveEpilogue
  >;

  using Gemm = hytlass::gemm::device::GemmUniversalAdapter<GemmKernel>;
  EXPECT_TRUE(test::gemm::device::TestAll<Gemm>());
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////// TN //////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

TEST(GFX928_Device_Gemm_f16t_f16n_f16n_align4_tensor_op_f32, 128x128x64) {
  using LayoutA = hytlass::layout::RowMajor;
  using LayoutB = hytlass::layout::ColumnMajor;
  using LayoutC = hytlass::layout::ColumnMajor;

  using CollectiveOp = typename hytlass::gemm::collective::CollectiveBuilder<
      hytlass::arch::Gfx928, hytlass::arch::OpClassTensorOp,
      hytlass::half_t, LayoutA, 4,
      hytlass::half_t, LayoutB, 4,
      float,
      Shape<_128,_128,_64>, Shape<_2,_2,_1>,
      Shape<_32,_32,_16>, Shape<_1,_1,_1>,
      hytlass::gemm::collective::StageCount<2>,
      hytlass::gemm::collective::KernelScheduleAuto
    >::CollectiveOp;

  using CollectiveEpilogue = typename hytlass::epilogue::collective::CollectiveBuilder<
      hytlass::arch::Gfx928, hytlass::arch::OpClassTensorOp,
      Shape<_128,_128,_64>, Shape<_1,_1,_1>,
      hytlass::epilogue::collective::EpilogueTileAuto,
      float, float,
      hytlass::half_t, LayoutC, 4,
      hytlass::half_t, LayoutC, 4,
      hytlass::epilogue::collective::EpilogueScheduleAuto
    >::CollectiveOp;

  using GemmKernel = hytlass::gemm::kernel::GemmUniversal<
      Shape<int,int,int,int>,
      CollectiveOp,
      CollectiveEpilogue
  >;

  using Gemm = hytlass::gemm::device::GemmUniversalAdapter<GemmKernel>;
  EXPECT_TRUE(test::gemm::device::TestAll<Gemm>());
}

///////////////////////////////////////////////////////////////////////////////

TEST(GFX928_Device_Gemm_f16t_f16n_f16n_align2_tensor_op_f32, 128x128x64) {
  using LayoutA = hytlass::layout::RowMajor;
  using LayoutB = hytlass::layout::ColumnMajor;
  using LayoutC = hytlass::layout::ColumnMajor;

  using CollectiveOp = typename hytlass::gemm::collective::CollectiveBuilder<
      hytlass::arch::Gfx928, hytlass::arch::OpClassTensorOp,
      hytlass::half_t, LayoutA, 2,
      hytlass::half_t, LayoutB, 2,
      float,
      Shape<_128,_128,_64>, Shape<_2,_2,_1>,
      Shape<_32,_32,_16>, Shape<_1,_1,_1>,
      hytlass::gemm::collective::StageCount<2>,
      hytlass::gemm::collective::KernelScheduleAuto
    >::CollectiveOp;

  using CollectiveEpilogue = typename hytlass::epilogue::collective::CollectiveBuilder<
      hytlass::arch::Gfx928, hytlass::arch::OpClassTensorOp,
      Shape<_128,_128,_64>, Shape<_1,_1,_1>,
      hytlass::epilogue::collective::EpilogueTileAuto,
      float, float,
      hytlass::half_t, LayoutC, 2,
      hytlass::half_t, LayoutC, 2,
      hytlass::epilogue::collective::EpilogueScheduleAuto
    >::CollectiveOp;

  using GemmKernel = hytlass::gemm::kernel::GemmUniversal<
      Shape<int,int,int,int>,
      CollectiveOp,
      CollectiveEpilogue
  >;

  using Gemm = hytlass::gemm::device::GemmUniversalAdapter<GemmKernel>;
  EXPECT_TRUE(test::gemm::device::TestAll<Gemm>());
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////// NT //////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

TEST(GFX928_Device_Gemm_f16n_f16t_f16n_align4_tensor_op_f32, 128x128x64) {
  using LayoutA = hytlass::layout::ColumnMajor;
  using LayoutB = hytlass::layout::RowMajor;
  using LayoutC = hytlass::layout::ColumnMajor;

  using CollectiveOp = typename hytlass::gemm::collective::CollectiveBuilder<
      hytlass::arch::Gfx928, hytlass::arch::OpClassTensorOp,
      hytlass::half_t, LayoutA, 4,
      hytlass::half_t, LayoutB, 4,
      float,
      Shape<_128,_128,_64>, Shape<_2,_2,_1>,
      Shape<_32,_32,_16>, Shape<_1,_1,_1>,
      hytlass::gemm::collective::StageCount<2>,
      hytlass::gemm::collective::KernelScheduleAuto
    >::CollectiveOp;

  using CollectiveEpilogue = typename hytlass::epilogue::collective::CollectiveBuilder<
      hytlass::arch::Gfx928, hytlass::arch::OpClassTensorOp,
      Shape<_128,_128,_64>, Shape<_1,_1,_1>,
      hytlass::epilogue::collective::EpilogueTileAuto,
      float, float,
      hytlass::half_t, LayoutC, 4,
      hytlass::half_t, LayoutC, 4,
      hytlass::epilogue::collective::EpilogueScheduleAuto
    >::CollectiveOp;

  using GemmKernel = hytlass::gemm::kernel::GemmUniversal<
      Shape<int,int,int,int>,
      CollectiveOp,
      CollectiveEpilogue
  >;

  using Gemm = hytlass::gemm::device::GemmUniversalAdapter<GemmKernel>;
  EXPECT_TRUE(test::gemm::device::TestAll<Gemm>());
}

///////////////////////////////////////////////////////////////////////////////

TEST(GFX928_Device_Gemm_f16n_f16t_f16n_align2_tensor_op_f32, 128x128x64) {
  using LayoutA = hytlass::layout::ColumnMajor;
  using LayoutB = hytlass::layout::RowMajor;
  using LayoutC = hytlass::layout::ColumnMajor;

  using CollectiveOp = typename hytlass::gemm::collective::CollectiveBuilder<
      hytlass::arch::Gfx928, hytlass::arch::OpClassTensorOp,
      hytlass::half_t, LayoutA, 2,
      hytlass::half_t, LayoutB, 2,
      float,
      Shape<_128,_128,_64>, Shape<_2,_2,_1>,
      Shape<_32,_32,_16>, Shape<_1,_1,_1>,
      hytlass::gemm::collective::StageCount<2>,
      hytlass::gemm::collective::KernelScheduleAuto
    >::CollectiveOp;

  using CollectiveEpilogue = typename hytlass::epilogue::collective::CollectiveBuilder<
      hytlass::arch::Gfx928, hytlass::arch::OpClassTensorOp,
      Shape<_128,_128,_64>, Shape<_1,_1,_1>,
      hytlass::epilogue::collective::EpilogueTileAuto,
      float, float,
      hytlass::half_t, LayoutC, 2,
      hytlass::half_t, LayoutC, 2,
      hytlass::epilogue::collective::EpilogueScheduleAuto
    >::CollectiveOp;

  using GemmKernel = hytlass::gemm::kernel::GemmUniversal<
      Shape<int,int,int,int>,
      CollectiveOp,
      CollectiveEpilogue
  >;

  using Gemm = hytlass::gemm::device::GemmUniversalAdapter<GemmKernel>;
  EXPECT_TRUE(test::gemm::device::TestAll<Gemm>());
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////// NN //////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

TEST(GFX928_Device_Gemm_f16n_f16n_f16n_align4_tensor_op_f32, 128x128x64) {
  using LayoutA = hytlass::layout::ColumnMajor;
  using LayoutB = hytlass::layout::ColumnMajor;
  using LayoutC = hytlass::layout::ColumnMajor;

  using CollectiveOp = typename hytlass::gemm::collective::CollectiveBuilder<
      hytlass::arch::Gfx928, hytlass::arch::OpClassTensorOp,
      hytlass::half_t, LayoutA, 4,
      hytlass::half_t, LayoutB, 4,
      float,
      Shape<_128,_128,_64>, Shape<_2,_2,_1>,
      Shape<_32,_32,_16>, Shape<_1,_1,_1>,
      hytlass::gemm::collective::StageCount<2>,
      hytlass::gemm::collective::KernelScheduleAuto
    >::CollectiveOp;

  using CollectiveEpilogue = typename hytlass::epilogue::collective::CollectiveBuilder<
      hytlass::arch::Gfx928, hytlass::arch::OpClassTensorOp,
      Shape<_128,_128,_64>, Shape<_1,_1,_1>,
      hytlass::epilogue::collective::EpilogueTileAuto,
      float, float,
      hytlass::half_t, LayoutC, 4,
      hytlass::half_t, LayoutC, 4,
      hytlass::epilogue::collective::EpilogueScheduleAuto
    >::CollectiveOp;

  using GemmKernel = hytlass::gemm::kernel::GemmUniversal<
      Shape<int,int,int,int>,
      CollectiveOp,
      CollectiveEpilogue
  >;

  using Gemm = hytlass::gemm::device::GemmUniversalAdapter<GemmKernel>;
  EXPECT_TRUE(test::gemm::device::TestAll<Gemm>());
}

///////////////////////////////////////////////////////////////////////////////

TEST(GFX928_Device_Gemm_f16n_f16n_f16n_align2_tensor_op_f32, 128x128x64) {
  using LayoutA = hytlass::layout::ColumnMajor;
  using LayoutB = hytlass::layout::ColumnMajor;
  using LayoutC = hytlass::layout::ColumnMajor;

  using CollectiveOp = typename hytlass::gemm::collective::CollectiveBuilder<
      hytlass::arch::Gfx928, hytlass::arch::OpClassTensorOp,
      hytlass::half_t, LayoutA, 2,
      hytlass::half_t, LayoutB, 2,
      float,
      Shape<_128,_128,_64>, Shape<_2,_2,_1>,
      Shape<_32,_32,_16>, Shape<_1,_1,_1>,
      hytlass::gemm::collective::StageCount<2>,
      hytlass::gemm::collective::KernelScheduleAuto
    >::CollectiveOp;

  using CollectiveEpilogue = typename hytlass::epilogue::collective::CollectiveBuilder<
      hytlass::arch::Gfx928, hytlass::arch::OpClassTensorOp,
      Shape<_128,_128,_64>, Shape<_1,_1,_1>,
      hytlass::epilogue::collective::EpilogueTileAuto,
      float, float,
      hytlass::half_t, LayoutC, 2,
      hytlass::half_t, LayoutC, 2,
      hytlass::epilogue::collective::EpilogueScheduleAuto
    >::CollectiveOp;

  using GemmKernel = hytlass::gemm::kernel::GemmUniversal<
      Shape<int,int,int,int>,
      CollectiveOp,
      CollectiveEpilogue
  >;

  using Gemm = hytlass::gemm::device::GemmUniversalAdapter<GemmKernel>;
  EXPECT_TRUE(test::gemm::device::TestAll<Gemm>());
}

///////////////////////////////////////////////////////////////////////////////

