# Graphormer_pytorch

<div align=center>
    <img src="./doc/GF.png"/>
</div>

Graphormer 是一个深度学习软件包，它能让研究人员和开发人员为分子建模任务训练自定义模型。其旨在加速分子科学领域人工智能的研究与应用，例如材料发现、药物发现等，[项目网站](https://www.microsoft.com/en-us/research/project/graphormer/)。

Graphormer 的高级预训练版本仅在以下平台提供：[Azure Quantum Elements](https://quantum.microsoft.com/en-us/our-story/quantum-elements-overview)。

关于Graphormer的更多信息请前往[源码仓库](https://github.com/microsoft/Graphormer)或[用户手册]()


## 环境配置
### 硬件需求
DCU型号：K100_AI,节点数量：1台,卡数：2张。
### Docker
```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu22.04-dtk24.04.2-py3.10

docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/graphormer
# 克隆并安装 fairseq
git clone https://github.com/facebookresearch/fairseq.git
git checkout 98ebe4f
pip install -e .
python setup.py build_ext --inplace
# 安装其他库
pip install -r requirements.txt
# 克隆 graphormer
git clone https://github.com/microsoft/Graphormer.git
# 替换文件
cp -f ./algos.pyx ./Graphormer/graphormer/data/algos.pyx
cp -f ./pyg_dataset_lookup_table.py ./Graphormer/graphormer/data/pyg_datasets/pyg_dataset_lookup_table.py
```

## 数据集
[示例数据集ZINC下载地址](https://uc2b1e201a894fcdcefc45447d3d.dl.dropboxusercontent.com/cd/0/get/CxApk-pOjXqveTD0AlvvU9WEEA2_kVEX8ekJVJe1vichmkjzq-LY7rmslrJFughtnKezOb8HyijbDxpMWW0mc-B4TtGE2UofmHz5-2_jnkaFWigtF6opQQvQiwMge5JCCyCMUsPJV__YUagJZOFRucbe/file?dl=1#)
## 训练
```bash
cd ./Graphormer/examples/property_prediction
mkdir ./dataset/raw
# 下载ZINC数据集并解压，将文件cp到./dataset/raw下
unzip molecules.zip
cp ./molecules/atom_dict.pickle ./dataset/raw
cp ./molecules/bond_dict.pickle ./dataset/raw
cp ./molecules/train.pickle ./dataset/raw
cp ./molecules/test.pickle ./dataset/raw
cp ./molecules/val.pickle ./dataset/raw

# 修改fairseq安装路径，将训练命令复制粘贴到./zinc.sh
export PYTHONPATH=/you_path_of/fairseq:$PYTHONPATH
fairseq-train \
--user-dir ../../graphormer \
--num-workers 0 \
--find-unused-parameters \
--dataset-name zinc \
--dataset-source pyg \
--task graph_prediction \
--criterion l1_loss \
--arch graphormer_slim \
--num-classes 1 \
--attention-dropout 0.1 --act-dropout 0.1 --dropout 0.0 \
--optimizer adam --adam-betas '(0.9, 0.999)' --adam-eps 1e-8 --clip-norm 5.0 --weight-decay 0.01 \
--lr-scheduler polynomial_decay --power 1 --warmup-updates 60000 --total-num-update 400000 \
--lr 2e-4 --end-learning-rate 1e-9 \
--batch-size 64 \
--fp16 \
--data-buffer-size 20 \
--encoder-layers 12 \
--encoder-embed-dim 80 \
--encoder-ffn-embed-dim 80 \
--encoder-attention-heads 8 \
--max-epoch 2 \
--save-dir ./ckpts

# 启动训练, 第一次启动时会花费一些时间用于数据集转换，转换后的训练数据存放在./property_prediction/dataset/full/processed目录下
# 权重文件会保存在./property_prediction/ckpts下
bash zinc.sh
```
## 推理
无

## result
详见/graphormer/res文件夹

## 应用场景
### 算法类别
`训练微调`
### 热点应用行业
`金融,教育,政府,科研,制造,能源,交通`
## 源码仓库及问题反馈
- https://github.com/microsoft/Graphormer
## 参考资料
- https://github.com/ibm-granite/granite-speech-models