# 介绍
FastPT是基于python的应用编译工具，借助FastPT，开发人员可以在HCU上开发、部署基于pytorch的内含CUDA代码的应用。可以实现CUDA源码不转码直接编译，或源码转换到HIP格式代码后，通过hipcc适配编译。推荐优先使用不转码编译方式。

注：fastpt工具目前尚不支持cutlass类似三方库和内联汇编指令

# 安装

工具安装使用pip方式，安装前请确保环境中已安装了torch，并从光源社区-DAS中下载此工具的安装包。注意与python版本匹配。
```
cd path/to/whl
pip install fastpt*.whl  --no-deps
```
安装完成之后，可通过以下指令验证是否安装成功,指令执行后会显示当前fastpt的版本号。
```
python -c “import fastpt;print(fastpt.__version__)”
```

# 使用
关于fastpt的初始化使用可使用source  /usr/local/bin /fastpt  -H 来查看如何设置初始化的帮助信息
## 不转码编译
Fastpt-2.0之后支持不转码编译实现，即直接使用CUDA源码编译。安装FastPT工具的whl包后，通过以下指令初始化编译环境；然后按照官方指导编译方法处理即可。若组件本身的setup代码中设置了是否使用CUDA拓展的接口需要用户打开该设置后，才可进行编译适配。
```
source  /usr/local/bin/fastpt  -C
```
编译好组件安装后，使用组件时通过以下指令初始化使用环境
```
source  /usr/local/bin/fastpt  -E
```

## 转码编译
FastPT提供了HCU下，转码到HIP格式，通过hipcc进行编译的方法，实现基于torch的应用中CUDA代码移植到DCU平台，提高应用程序移植工作的效率。编译时，转码一般时自动实现的。另外提供了自定义接口映射用来补充代码映射关系，提供了CMake编译时的转码方法。

### 1 使用方法
此方法适用于通过setup.py使用CUDAExtension、CppExtension进行组件构建编译的场景。使用时通过以下指令初始化不转码适配环境，执行参考组件官方的构建文档，进行编译处理，但要注意不转码使用事项。
```
source  /usr/local/bin/fastpt -T
```

### 2 自定义接口映射
工具中可能存在未涉及到或用户需要的一些转换匹配，可以通过json文件的方式给到工具，在不需要额外修改代码的情况下，实现自定义代码匹配转换。可以通过以下方法补充代码映射。用户需要在CUDAExtension或hipify_python接口调用代码同级目录下，通常为setup.py文件所在目录，创建 custom_hipify_mappings.json文件。json文件内容格式如下，此示例中，在将CUDA代码转到HIP代码时，会将源码中的”src mapping 1”替换为”dst mapping 1”，将"src mapping 2" 替换成 "dst mapping 2"。自定义映射转换优先级高于内置的转换。

```
{
    "custom_map" : {
        "src mapping 1" : "dst mapping 1",
        "src mapping 2" : "dst mapping 2",
        ...
    }
}

```

### 3 转码时保持源码相对路径不变
可以通过hipify接口实现保留源代码路径的转码，转码会新建一个xxx_dtk的代码文件夹，内部文件路径结构与源文件夹下一致，”.cu”代码文件扩展名会转成”.hip”，如xxx.cu转码后为xxx.hip。此方法一般在CMake或Make等需要保持原代码路径的工具编译代码时使用，需要注意CMakeLists.txt中的代码需要手动修改，暂时不支持CMake语法的转码，如”.cu”后缀需要改为”.hip”、编译器nvcc需要改为hipcc等，此适配场景下建议使用3.1章节中的不转码编译处理。使用时，需要在要转码的文件夹的同级目录中实现以下脚本fastptcode.py:
```
import os
this_dir = os.path.dirname(os.path.abspath(__file__))
from  fastpt import hipify
res = hipify(
    project_directory=os.path.join(this_dir,'codepath'),
    includes = '*',
    show_detailed=True,
    is_pytorch_extension=True,
    keep_file_path=True  # 保持源代码文件夹内文件相对路径
    # ignores=["run_tests.sh.in"]  # 屏蔽掉不希望处理的代码
)
```
然后执行python fastptcode.py，会在codepath的同级目录下生成转码后的文件夹 codepath_dtk，此路径下的文件结构与codepath的结构相同，”.cu“代码文件后缀变为”.hip“。文件结构如下：
```
|
|----codepath
|----codepath_dtk
|----fastptcode.py
```

# 注意事项
1 不转码编译注意事项
```
（1）此工具适用于依赖torch的生态组件使用，应用中内含CUDA C/C++代码的工程在HCU环境下的开发、移植。当前torch版本要求最低torch2.4.1；
（2）不支持依赖cutlass、内嵌汇编代码的编译；
（3）部分代码可能存在不支持的情况，如__CUDA_ARCH__宏，可以在代码中设置或在编译指令中添加支持；
（4）部分编译指令不支持，如下示例中注释的”-gencode”，”arch=compute_75,code=sm_75”需要使用”-gencode=arch=compute_75,code=sm_75”替换。
    extra_compile_args={
                "cxx": [
                    "-O3",
                ]
                + generator_flag,
                "nvcc": [
                    "-O3",
                    "--use_fast_math",
                    #"-gencode",
                    #"arch=compute_75,code=sm_75",
                    '-gencode=arch=compute_75,code=sm_75',
                    ]
                + generator_flag,
            },

```
2 转码编译注意事项
```
（1）此工具适用于依赖torch的生态组件或应用，内含CUDA C/C++代码的工程在HCU环境下的开发、移植。当前torch版本要求torch2.4.1;
（2）暂不支持CMake、make等代码处理，可通过上面4.2中的方法，通过python脚本调用hipify接口，将CUDA代码转换成HIP代码，CMake文件需要用户自行处理,CXX指定为hipcc。为了便于适配使用走CMake编译的组件建议直接使用不转码的方式，走cuda源码编译适配；
（3）工程中存在三方依赖库时，三方库可能不被处理，此时需要开发者对三方依赖库自行处理;
（4）转码编译时，不需要执行 source /opt/dtk/cuda/env.sh; 
（5）适配组件的setup.py 中可能会有CUDA环境检查来决定是否执行CUDA相关代码的编译，可按情况进行处理。
```
# 已支持组件列表

|   | 组件名称 | 版本    | 功能支持情况 | DAS仓库 | 备注说明     |
| - | -------- | ------- | ------------ | ------- | ------------ |
| 1 | vision   | v0.19.1 |              |         |              |
| 2 | audio    | v2.4.1  |              |https://developer.sourcefind.cn/codes/OpenDAS/torchaudio| 部分代码修改 |
| 3 | fastmoe  | v1.1.0  |              |github 官方代码|              |
| 4 | lietorch | v0.2    |              |https://developer.sourcefind.cn/codes/OpenDAS/lietorch|部分代码修改    |
| 5 | maskrcnn |         |              |https://developer.sourcefind.cn/codes/OpenDAS/maskrcnn|头文件修改      |



