# 介绍
FastPT是基于python的应用编译工具，借助FastPT，开发人员可以在HCU上开发、部署基于pytorch的内含CUDA代码的应用。可以实现CUDA源码不转码直接编译，或源码转换到HIP格式代码后，通过hipcc适配编译。

# 安装

工具安装使用pip方式，安装前请确保环境中已安装了torch，并从光源社区-DAS中下载此工具的安装包。注意与python版本匹配。
cd path/to/whl
pip install fastpt*.whl
安装完成之后，可通过以下指令验证是否安装成功,指令执行后会显示当前fastpt的版本号。
python -c “import fastpt;print(fastpt.__version__)”

# 使用
## 转码编译
FastPT提供了HCU下，转码到HIP格式，通过hipcc进行编译的方法，实现基于torch的应用中CUDA代码移植到DCU平台，提高应用程序移植工作的效率。编译时，转码一般时自动实现的。另外提供了自定义接口映射用来补充代码映射关系（见4.2）；提供了CMake编译时的转码方法(见4.3)。

## 不转码编译
Fastpt最新版本支持不转码，直接使用CUDA源码编译，安装whl包后，执行source  ~./fastpt  -c，初始化fastpt编译环境，然后按照官方指导编译方法处理即可。若组件本身的setup代码中设置了是否使用CUDA拓展的接口需要用户打开该设置后，才可进行编译适配。编译好组件安装后，使用组件时执行source  ~/fastpt  -e初始化组件使用环境。

# 注意事项
不转码编译注意事项
（1）此工具适用于依赖torch的生态组件使用，应用中内含CUDA C/C++代码的工程在HCU环境下的开发、移植。当前torch版本要求最低torch2.4.1；
（2）不支持依赖cutlass、内嵌汇编代码的编译；
（3）部分代码可能存在不支持的情况，如__CUDA_ARCH__宏，可以在代码中设置或在编译指令中添加支持；
（4）部分编译指令不支持，如下示例中注释的”-gencode”，”arch=compute_75,code=sm_75”需要使用”-gencode=arch=compute_75,code=sm_75”替换。
转码编译注意事项
（1）此工具适用于依赖torch的生态组件或应用，内含CUDA C/C++代码的工程在HCU环境下的开发、移植。当前torch版本要求torch2.4.1;
（2）暂不支持CMake、make等代码处理，可通过上面4.2中的方法，通过python脚本调用hipify接口，将CUDA代码转换成HIP代码，CMake文件需要用户自行处理,CXX指定为hipcc。为了便于适配使用走CMake编译的组件建议直接使用不转码的方式，走cuda源码编译适配；
（3）工程中存在三方依赖库时，三方库可能不被处理，此时需要开发者对三方依赖库自行处理;
（4）转码编译时，不需要执行 source /opt/dtk/cuda/env.sh; 
（5）适配组件的setup.py 中可能会有CUDA环境检查来决定是否执行CUDA相关代码的编译，可按情况进行处理。

# 已支持组件列表

|   | 组件名称 | 版本    | 功能支持情况 | DAS仓库 | 备注说明     |
| - | -------- | ------- | ------------ | ------- | ------------ |
| 1 | vision   | v0.19.1 |              |         |              |
| 2 | audio    | v2.4.1  |              |https://developer.sourcefind.cn/codes/OpenDAS/torchaudio| 部分代码修改 |
| 3 | fastmoe  | v1.1.0  |              |github 官方代码|              |
| 4 | lietorch | v0.2    |              |https://developer.sourcefind.cn/codes/OpenDAS/lietorch|部分代码修改    |
| 5 | maskrcnn |         |              |https://developer.sourcefind.cn/codes/OpenDAS/maskrcnn|头文件修改      |



