try:
    import torch
except ImportError:
    pass
import subprocess
from pathlib import Path
import os
UNKNOWN = "Unknown"

def sha_value(moe_root):
    try:
        return (
            subprocess.check_output(["git", "rev-parse", "HEAD"], cwd=moe_root)
            .decode("ascii")
            .strip()
        )
    except Exception:
        return UNKNOWN

def abi_value():
    try:
        return (
            subprocess.check_output("echo '#include <string>' | gcc -x c++ -E -dM - | fgrep _GLIBCXX_USE_CXX11_ABI", shell=True)
            .decode('ascii')
            .strip()[-1]
        )
    except Exception:
        return UNKNOWN

def dtk_version_value():
    try:
       dtk_path=os.getenv('ROCM_PATH')
       dtk_version_path = os.path.join(dtk_path, '.info', "version-dev")
       with open(dtk_version_path, 'r',encoding='utf-8') as file:
           lines = file.readlines()
       dtk_version="dtk"+lines[0][:-2].replace(".", "")
       return dtk_version
    except Exception:
       return UNKNOWN


def torch_version_value():
    try:
       torch_version = "torch" + (torch.__version__).split('.')[0]+ "." +torch.__version__.split('.')[1]
       return torch_version
    except Exception:
       return UNKNOWN

def moe_whl_name():
    try:
        moe_root = Path(__file__).parent
        sha = "das1.1.git" + sha_value(moe_root)[0:7]
        abi = "abi" + abi_value()
        dtk_version = dtk_version_value()
        try:
            import torch
            torch_version = torch_version_value()
        except ImportError:
            torch_version = "null"
        whl_name = "+" + sha + "." + abi + "." + dtk_version + "." + torch_version
        return whl_name
    except Exception:
        return UNKNOWN

def dcu_version():
    try:
        moe_version = '1.1.0'
        dcu_version = moe_version + moe_whl_name()
        return dcu_version
    except Exception:
        return UNKNOWN

