# <div align="center"><strong>FastMoe</strong></div>
## 简介
一个易于使用和高效的系统，支持PyTorch的混合专家(MoE)模型。
## 安装
  
  源码编译安装，该方式需要安装torch及fastpt工具包；注意使用fastpt包进行源码编译安装时，要严格匹配fastpt、torch、dtk之间的版本号，例如基于dtk2504编译，则fastpt、torch都必须是dtk2504的包，其中fastpt与torch对应的版本号关系为
|   | fastpt版本 | torch版本    | DTK版本 | 
| - | -------- | ------- | ------------ | 
| 1 | 2.0.1+das.dtk2504   | v2.4.1 |  dtk2504| 
| 1 | 2.1.0+das.dtk2504   | v2.5.1 |  dtk2504| 
| 1 | 2.0.1+das.dtk25041   | v2.4.1 |  dtk25041| 
| 1 | 2.1.0+das.dtk25041   | v2.5.1 |  dtk25041| 
## 编译流程
  ```
  pip3 install dm-tree
  pip3 install pytest
  pip3 install wheel
  pip3 install fastpt-2.0.1+das.dtk2504-py3-none-any.whl #以torch2.4.1，dtk2504为例
  git clone https://developer.hpccube.com/codes/OpenDAS/fastmoe.git
  git checkout v1.1.0-fastpt* #切换到相应分支
  cd fastmoe
  source  /usr/local/bin/fastpt -c
  python3 setup.py build
  python3 setup.py install 
  python3 setup.py bdist_wheel # 该指令用于编译whl包，执行该指令时不必执行前两个指令
  ```
## 验证安装
```
source  /usr/local/bin/fastpt -e
pip3 list | grep fastmoe
python3
import fmoe 
fmoe.__version__
#返回版本号
```
## 测试
```
source  /usr/local/bin/fastpt -e
cd fastmoe/tests
pytest vs

```
