# <div align="center"><strong>MMCV</strong></div>
## 简介
Faiss 是一个用于高效相似性搜索和密集向量聚类的库。它提供了在各种规模的向量集合中进行搜索的算法，包括那些可能无法完全适应 RAM 的大型集合。除了搜索功能，Faiss 还包含用于评估和参数调优的支持代码
## 安装
组件支持
+ Python 3.7、3.8、3.9、3.10

### 1、使用pip方式安装
mmcv whl包下载目录：[http://10.6.10.68:8000/debug/faiss/dtk-24.04.1/](http://10.6.10.68:8000/debug/faiss/dtk-24.04.1/)，选择对应的pytorch版本和python版本下载对应faiss的whl包
```shell
pip install faiss* (下载的faiss的whl包)
```
### 2、使用源码编译方式安装
基于光源pytorch基础镜像环境：镜像下载地址：[https://sourcefind.cn/#/image/dcu/pytorch](https://sourcefind.cn/#/image/dcu/pytorch)，根据pytorch、python、dtk及系统下载对应的镜像版本。
#### 源码编译安装
- 代码下载
```shell
git clone http://10.6.10.68/dcutoolkit/deeplearing/faiss.git # 根据编译需要切换分支
```
- 提供2种源码编译方式（进入faiss目录）：
```
1. 编译whl包并安装
pip3 install wheel 
pip3 install pytest  
mkdir -p build
cd build
source /opt/dtk/env.sh
export BUILD_DIR=`pwd`
export LD_LIBRARY_PATH=${BUILD_DIR}/faiss/gpu/test/:${BUILD_DIR}/faiss/:${BUILD_DIR}/lib/:$LD_LIBRARY_PATH
CXX=hipcc CC=hipcc  cmake -DFAISS_ENABLE_GPU=ON -DBUILD_SHARED_LIBS=ON -DFAISS_OPT_LEVEL=avx -DBUILD_TESTING=ON -DCMAKE_BUILD_TYPE=RELEASE -DCMAKE_MODULE_PATH="${ROCM_PATH}/hip/cmake"  -DCMAKE_INSTALL_PREFIX=${BUILD_DIR}/install  -DMKL_LIBRARIES=/opt/intel/compilers_and_libraries_2020.4.304/linux/mkl/lib/intel64_lin/libmkl_rt.so ..
make 
cd faiss/python
python3 setup.py bdist_wheel
cd dist  
pip3 install faiss-* --no-deps  --force
验证安装：
python3
Python 3.10.12 (main, May 26 2024, 00:14:02) [GCC 9.4.0] on linux
Type "help", "copyright", "credits" or "license" for more information.
>>> import faiss
>>> faiss.__version__
'1.7.2'
>>> faiss.__dcu_version__
'1.7.2+das.dtk24041'
>>>

2. 源码编译安装
mkdir -p build
cd build
source /opt/dtk/env.sh
export BUILD_DIR=`pwd`
export LD_LIBRARY_PATH=${BUILD_DIR}/faiss/gpu/test/:${BUILD_DIR}/faiss/:${BUILD_DIR}/lib/:$LD_LIBRARY_PATH
CXX=hipcc CC=hipcc  cmake -DFAISS_ENABLE_GPU=ON -DBUILD_SHARED_LIBS=ON -DFAISS_OPT_LEVEL=avx -DBUILD_TESTING=ON -DCMAKE_BUILD_TYPE=RELEASE -DCMAKE_MODULE_PATH="${ROCM_PATH}/hip/cmake"  -DCMAKE_INSTALL_PREFIX=${BUILD_DIR}/install  -DMKL_LIBRARIES=/opt/intel/compilers_and_libraries_2020.4.304/linux/mkl/lib/intel64_lin/libmkl_rt.so ..
make && make install 
```
## 单测
```
cd faiss/tests
pytest -vs
cd faiss/build
ctest
```
## Known Issue
- 无
