# <div align="center"><strong>Fairseq</strong></div>
## 简介
Fairseq（-py） 是一个序列建模工具包，它允许研究人员和开发人员训练用于翻译、摘要、语言的自定义模型建模和其他文本生成任务。DAS软件栈中的Fairseq版本，不仅保证了组件核心功能在DCU加速卡的可用性,还针对DCU特有的硬件架构进行了深度定制优化。这使得开发者能够以极低的成本，轻松实现应用程序在DCU加速卡上的快速迁移和性能提升。

## 安装
组件支持组合

   | PyTorch版本 | fastpt版本  |Fairseq版本      | DTK版本              | Python版本       | 推荐编译方式 |
   | ----------- | ----------- | ----------- | ------------------------ | ---------------- | ------------ |
   | 2.5.1       | 2.1.0       |0.9.0        | >= 25.04                 | 3.8、3.10、3.11  | fastpt不转码 |
   | 2.4.1       | 2.0.1       |0.9.0        | >= 25.04                 | 3.8、3.10、3.11  | fastpt不转码 |
   | 其他        | 其他        | 其他        | 其他                     | 3.8、3.10、3.11  | hip转码      |

+ pytorch版本大于2.4.1 && dtk版本大于25.04 推荐使用fastpt不转码编译。

### 1、使用pip方式安装
fairseq whl包下载目录：[光和开发者社区](https://download.sourcefind.cn:65024/4/main/fairseq)，选择对应的pytorch版本和python版本下载对应fairseq的whl包
```shell
pip install torch* (下载torch的whl包)
pip install fastpt* --no-deps (下载fastpt的whl包)
source  /usr/local/bin/fastpt -E
pip install fairseq* (下载的fairseq-fastpt的whl包)
```
### 2、使用源码编译方式安装

#### 编译环境准备
提供基于fastpt不转码编译：

1. 基于光源pytorch基础镜像环境：镜像下载地址：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据pytorch、python、dtk及系统下载对应的镜像版本。

2. 基于现有python环境：安装pytorch，fastpt whl包下载目录：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据python、dtk版本,下载对应pytorch的whl包。安装命令如下：
```shell
pip install torch* (下载torch的whl包)
pip install fastpt* --no-deps (下载fastpt的whl包, 安装顺序，先安装torch，后安装fastpt)
pip install wheel
```

#### 源码编译安装
- 代码下载
```shell
git clone http://developer.sourcefind.cn/codes/OpenDAS/fairseq.git # 根据编译需要切换分支
```
- 提供2种源码编译方式（进入fairseq目录）：
```
1. 设置不转码编译环境变量
source /usr/local/bin/fastpt -C

2. 编译whl包并安装
python3 setup.py -v bdist_wheel
pip install dist/fairseq*

3. 源码编译安装
pip3 install --editable ./
```
#### 注意事项
+ 若使用pip install下载安装过慢，可添加pypi清华源：-i https://pypi.tuna.tsinghua.edu.cn/simple/
+ ROCM_PATH为dtk的路径，默认为/opt/dtk

## 验证
- python -c "import fairseq; fairseq.\_\_version__"，版本号与官方版本同步，查询该软件的版本号，例如0.9.0；

## Known Issue
- 无

## 参考资料
- [README_ORIGIN](README_ORIGIN.md)
- [https://github.com/facebookresearch/fairseq](https://github.com/facebookresearch/fairseq)
