#!/bin/bash

pip install -r requirements.txt
pip install pygit2
pip install pgzip

set -e

source /opt/dtk/env.sh
source /usr/local/bin/fastpt -C
export BUILD_CUDA_EXTENSIONS=1
export HIPCC_COMPILE_FLAGS_APPEND="--gpu-max-threads-per-block=1024"

echo "开始编译组件fairscale"
python3 setup.py -v bdist_wheel
echo "组件fairscale编译完成"

ls dist/
pip install dist/fairscale*.whl --force-reinstall --no-deps

echo "组件fairscale安装完成"


echo "开始fairscale单元测试"
if command -v pytest &> /dev/null; then
    echo "pytest 已安装，版本: $(pytest --version)"
    # 跳过安装
else
    echo "pytest 未安装，正在安装..."
    # 使用 pip 安装 (最常见)
    pip install pytest
fi

pytest -vs ./tests

