

# fairscale

`fairscale`是一个用于高性能和大规模训练的`pytorch`扩展库。 此库扩展了基本的`pytorch`功能，同时添加了新的SOTA扩展技术。 `fairscale`以可组合模块和易于使用的API的形式提供了最新的分布式训练技术。 参考官方文档[README_ORIGIN.md](README_ORIGIN.md)



# 安装
组件支持：

* dtk-23.10
* pytorch-2.1

## pip安装

在[光合开发者社区](https://developer.hpccube.com/tool/#sdk) AI 生态包中获取对应的fairscale安装包。
```
pip install fairscale*
```

## 源码安装

```shell
git clone https://github.com/facebookresearch/fairscale.git # 根据需要切换分支
cd fairscale
# 支持GPU需要添加环境变量
export BUILD_CUDA_EXTENSIONS=1
export HIPCC_COMPILE_FLAGS_APPEND="--gpu-max-threads-per-block=1024"
pip install -r requirements.txt
# -e signified dev mode since e stands for editable
pip install -e .
```

如果安装失败，尝试在 `pip install` 命令后，添加 `--no-build-isolation` 选项。

## 其它

torch安装之后，如有库缺失导致的错误，参考以下库的安装

* 安装 `intel-mkl`库

  ```shell
  yum-config-manager --add-repo https://yum.repos.intel.com/mkl/setup/intel-mkl.repo
  yum install intel-mkl-2020.0-088 -y --nogpgchec
  ```

  并将库路径添加到环境变量：

  ```shell
  export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/opt/intel/mkl/lib/intel64
  ```



* 安装 `magma`

  ```shell
  # 默认dtk安装路径为 /opt/dtk
  cd /opt/dtk 
  wget http://10.6.10.68:8000/debug/pytorch/third_party/magma_v2.7.2-hip_nfs3.2_DTK23.10_intel-2020.1.217_07Oct2023.tar.gz
  tar -zxf magma_v2.7.2-hip_nfs3.2_DTK23.10_intel-2020.1.217_07Oct2023.tar.gz
  mv magma_v2.7.2-hip_nfs3.2_DTK23.10_intel-2020.1.217_07Oct2023 magma
  cd magma/lib/
  # 添加环境变量
  export LD_LIBRARY_PATH=${ROCM_PATH}/magma/lib:$LD_LIBRARY_PATH
  ```

# 验证
  查询软件版本号，与官方版本同步。
   ```
   python -c "import fairscale; print(fairscale.__version__)"
   ```

