# Copyright (c) Facebook, Inc. and its affiliates. All rights reserved.

from typing import Any, List, Iterable, Union, Callable, Optional
from .. import Tensor

_params_t = Union[Iterable[Tensor], Iterable[dict]]

class Optimizer(object):
    param_groups: List[dict]
    state: dict
    def __init__(self, params: _params_t, defaults: dict) -> None: ...
    def state_dict(self) -> dict: ...
    def load_state_dict(self, state_dict: dict) -> None: ...
    def zero_grad(self) -> None: ...
    def step(self, closure: Optional[Callable[[], float]]=...) -> Optional[float]: ...
    def add_param_group(self, param_group: dict) -> None: ...
