	# Copyright (c) Facebook, Inc. and its affiliates. All rights reserved.

from typing import Any, List, Dict, Iterable, Union, Callable, Optional
from .. import Tensor

_params_t = Union[Iterable[Tensor], Iterable[Dict]]

class Optimizer(object):
    param_groups: List[Dict]
    state: Dict
    def __init__(self, params: _params_t, defaults: Optional[Dict]=None, lr: Optional[float]=None) -> None: ...
    def __getattr__(self, name: str) -> Any: ...
    def state_dict(self) -> Dict: ...
    def load_state_dict(self, state_dict: Dict) -> None: ...
    def zero_grad(self) -> None: ...
    def step(self, closure: Optional[Callable[[], float]]=...) -> Optional[float]: ...
    def add_param_group(self, param_group: Dict) -> None: ...
