# <div align="center"><strong>fairscale</strong></div>
## 简介
`fairscale`是一个用于高性能和大规模训练的`pytorch`扩展库。 此库扩展了基本的`pytorch`功能，同时添加了新的SOTA扩展技术。 `fairscale`以可组合模块和易于使用的API的形式提供了最新的分布式训练技术。

## 安装
组件支持组合

   | PyTorch版本 | fastpt版本  |fairscale版本 | DTK版本      | Python版本       | 推荐编译方式 |
   | ----------- | ----------- | ------------ | ------------ | ---------------- | ------------ |
   | 2.5.1       | 2.1.0       |0.4.9         | >= 25.04     | 3.8、3.10、3.11  | fastpt不转码 |
   | 2.4.1       | 2.0.1       |0.4.9         | >= 25.04     | 3.8、3.10、3.11  | fastpt不转码 |
   | 其他        | 其他        | 其他         | 其他         | 3.8、3.10、3.11  | hip转码      |

+ pytorch版本大于2.4.1 && dtk版本大于25.04 推荐使用fastpt不转码编译。

### 1、使用pip方式安装
fairscale whl包下载目录：[光和开发者社区](https://download.sourcefind.cn:65024/4/main/)，选择对应的pytorch版本和python版本下载对应fairscale的whl包
```shell
pip install torch* (下载torch的whl包)
pip install fastpt* --no-deps (下载fastpt的whl包)
source  /usr/local/bin/fastpt -E
pip install fairscale* (下载的fairscale-fastpt的whl包)
```
### 2、使用源码编译方式安装

#### 编译环境准备
提供基于fastpt不转码编译：

1. 基于光源pytorch基础镜像环境：镜像下载地址：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据pytorch、python、dtk及系统下载对应的镜像版本。

2. 基于现有python环境：安装pytorch，fastpt whl包下载目录：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据python、dtk版本,下载对应pytorch的whl包。安装命令如下：
```shell
pip install torch* (下载torch的whl包)
pip install fastpt* --no-deps (下载fastpt的whl包, 安装顺序，先安装torch，后安装fastpt)
pip install setuptools==59.5.0 wheel
pip install -r requirements.txt
```

#### 源码编译安装
- 代码下载
```shell
git clone http://developer.sourcefind.cn/codes/OpenDAS/fairscale.git # 根据编译需要切换分支
```
- 提供2种源码编译方式（进入fairscale目录）：

1. 设置不转码编译环境变量
```shell
export BUILD_CUDA_EXTENSIONS=1
export HIPCC_COMPILE_FLAGS_APPEND="--gpu-max-threads-per-block=1024"
source /usr/local/bin/fastpt -C
```
2. 编译whl包并安装
```shell
python3 setup.py -v bdist_wheel
pip install dist/fairscale*
```
3. 源码编译安装
```shell
python3 setup.py install | pip install -e .
```

#### 注意事项
+ 若使用pip install下载安装过慢，可添加pypi清华源：-i https://pypi.tuna.tsinghua.edu.cn/simple/
+ ROCM_PATH为dtk的路径，默认为/opt/dtk

## 验证
- python -c "import fairscale; fairscale.\_\_version__"，版本号与官方版本同步，查询该软件的版本号，例如0.4.9

## Known Issue

如果安装失败，尝试在 `pip install` 命令后，添加 `--no-build-isolation` 选项。
torch安装之后，如有库缺失导致的错误，参考以下库的安装

- 安装 `intel-mkl`库

  ```shell
  yum-config-manager --add-repo https://yum.repos.intel.com/mkl/setup/intel-mkl.repo
  yum install intel-mkl-2020.0-088 -y --nogpgchec
  并将库路径添加到环境变量：
  export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/opt/intel/mkl/lib/intel64
  ```

## 参考资料
- [README_ORIGIN.md](README_ORIGIN.md)
- [https://github.com/facebookresearch/fairscale](https://github.com/facebookresearch/fairscale)
