// Copyright (C) 2015  Davis E. King (davis@dlib.net)
// License: Boost Software License   See LICENSE.txt for the full license.
#ifndef DLIB_ROCM_ERRORs_H_
#define DLIB_ROCM_ERRORs_H_


#include "../error.h"

namespace dlib
{
    struct hip_error : public error
    {
        /*!
            WHAT THIS OBJECT REPRESENTS
                This is the exception thrown if any calls to the NVIDIA ROCM runtime
                returns an error.  
        !*/

        hip_error(const std::string& message): error(message) {}
    };


    struct hipdnn_error : public hip_error
    {
        /*!
            WHAT THIS OBJECT REPRESENTS
                This is the exception thrown if any calls to the NVIDIA cuDNN library
                returns an error.  
        !*/

        hipdnn_error(const std::string& message): hip_error(message) {}
    };

    struct hiprand_error : public hip_error
    {
        /*!
            WHAT THIS OBJECT REPRESENTS
                This is the exception thrown if any calls to the NVIDIA cuRAND library
                returns an error.  
        !*/

        hiprand_error(const std::string& message): hip_error(message) {}
    };

    struct rocblas_error : public hip_error
    {
        /*!
            WHAT THIS OBJECT REPRESENTS
                This is the exception thrown if any calls to the NVIDIA cuBLAS library
                returns an error.  
        !*/

        rocblas_error(const std::string& message): hip_error(message) {}
    };

    struct hipsolver_error : public hip_error
    {
        /*!
            WHAT THIS OBJECT REPRESENTS
                This is the exception thrown if any calls to the NVIDIA cuSolver library
                returns an error.  
        !*/

        hipsolver_error(const std::string& message): hip_error(message) {}
    };
}


#endif // DLIB_ROCM_ERRORs_H_

