# DLIB

## 环境配置

使用DCU编译之前，需要准备编译环境。参考
[environment prepare](environment_prepare.md)

## 使用源码安装

### 编译环境准备（以dtk-23.04版本为例）

- 拉取 apex 代码

  ```
  git clone -b dtk-23.04 http://developer.hpccube.com/codes/aicomponent/dlib.git
  ```
- 在[开发者社区](https://developer.hpccube.com/tool/#sdk) DCU Toolkit 中下载 DTK-23.04 解压至 /opt/ 路径下，并建立软链接

  ```
  cd /opt && ln -s dtk-23.04 dtk
  ```

- 导入环境变量以及安装必要依赖库

  ```shell
  source /opt/dtk/env.sh
  ```

### 编译安装

#### 使用cmake编译

```shell
mkdir build; cd build; 
cmake .. -DCMAKE_CXX_COMPILER=/opt/dtk/bin/hipcc

cmake --build . -j16 #--verbose
```

#### 单元测试

Running the unit test suite.
Type the following to compile and run the dlib unit test suite:

- 编译单元测试

```shell
cd dlib/test
mkdir build
cd build

cmake .. -DCMAKE_CXX_COMPILER=/opt/dtk/bin/hipcc
cmake --build . -j16 --config Release #--verbose
```

- 进行单元测试

```shell
./dtest --runall    # 全部测试
./dtest -d --test_rocblas    # 测试单个测试单元
```

#### 编译 dlib Python API

- 使用python安装

```shell
python setup.py install --set CMAKE_CXX_COMPILER=/opt/dtk/bin/hipcc
```

- 使用python编译whl包

```shell
python setup.py bdist_wheel --set CMAKE_CXX_COMPILER=/opt/dtk/bin/hipcc
```
 