# dlib C++ library  [![GitHub Actions C++ Status](https://github.com/davisking/dlib/actions/workflows/build_cpp.yml/badge.svg)](https://github.com/davisking/dlib/actions/workflows/build_cpp.yml) [![GitHub Actions Python Status](https://github.com/davisking/dlib/actions/workflows/build_python.yml/badge.svg)](https://github.com/davisking/dlib/actions/workflows/build_python.yml)

Dlib is a modern C++ toolkit containing machine learning algorithms and tools for creating complex software in C++ to solve real world problems.
See [http://dlib.net](http://dlib.net) for the main project documentation and API reference.

## Compiling dlib C++ example programs

Go into the examples folder and type:

DCU编译之前，需要准备编译环境  
[environment_prepare](environment_prepare.md)

```shell
mkdir build; cd build; 
cmake .. -DCMAKE_CXX_COMPILER=/opt/dtk/bin/hipcc
cmake --build . -j16 --verbose
```

That will build all the examples.
If you have a CPU that supports AVX instructions then turn them on like this:

```shell
mkdir build; cd build; cmake .. -DUSE_AVX_INSTRUCTIONS=1; cmake --build .
```

Doing so will make some things run faster.

Finally, Visual Studio users should usually do everything in 64bit mode. By default Visual Studio is 32bit, both in its outputs and its own execution, so you have to explicitly
tell it to use 64bits. Since it's not the 1990s anymore you probably want to use 64bits. Do that with a cmake invocation like this:

```shell
cmake .. -G "Visual Studio 14 2015 Win64" -T host=x64 
```

## Compiling your own C++ programs that use dlib

The examples folder has a [CMake tutorial](https://github.com/davisking/dlib/blob/master/examples/CMakeLists.txt) that tells you what to do. There are also additional instructions
on the [dlib web site](http://dlib.net/compile.html).

```shell
vcpkg install dlib
```

## Compiling dlib Python API

Before you can run the Python example programs you must compile dlib. Type:

```shell
python setup.py install --set CMAKE_CXX_COMPILER=/opt/dtk/bin/hipcc
```

## Running the unit test suite

Type the following to compile and run the dlib unit test suite:

```shell
cd dlib/test
mkdir build
cd build

cmake .. -DCMAKE_CXX_COMPILER=/opt/dtk/bin/hipcc
cmake --build . -j16 --config Release --verbose

./dtest --runall
./dtest -d --test_dnn
```

Note that on windows your compiler might put the test executable in a subfolder called `Release`. If that's the case then you have to go to that folder before running the test.

This library is licensed under the Boost Software License, which can be found in [dlib/LICENSE.txt](https://github.com/davisking/dlib/blob/master/dlib/LICENSE.txt). The long and
short of the license is that you can use dlib however you like, even in closed source commercial software.

## dlib sponsors

This research is based in part upon work supported by the Office of the Director of National Intelligence (ODNI), Intelligence Advanced Research Projects Activity (IARPA) under
contract number 2014-14071600010. The views and conclusions contained herein are those of the authors and should not be interpreted as necessarily representing the official
policies or endorsements, either expressed or implied, of ODNI, IARPA, or the U.S. Government.

