################################################################################################
# Config hip compilation.
# Usage:
#   dgl_config_hip(<dgl_cuda_src>)
macro(dgl_config_hip out_variable)
  if(NOT HIP_FOUND)
    message(FATAL_ERROR "Cannot find HIP.")
  endif()
  # always set the includedir when cuda is available
  # avoid global retrigger of cmake
	include_directories(${CUDA_INCLUDE_DIRS})

  add_definitions(-DDGL_USE_CUDA)
  add_definitions(-D__HIP_PLATFORM_AMD__)
  add_definitions(-DCUDART_VERSION_LT_11000=true)
  add_definitions(-DDTKRT_VERSION=11080)
  add_definitions(-D__DTK_ARCH__=11080)

  include_directories(BEFORE SYSTEM "${CMAKE_SOURCE_DIR}/include/")
  message(STATUS ">>>>>>>>>>>> CUDA_INCLUDE_DIRS : ${CUDA_INCLUDE_DIRS}")
  set_source_files_properties(src/random/random.cc PROPERTIES HIP_SOURCE_PROPERTY_FORMAT 1)
  set_source_files_properties(src/array/cuda/csr_transpose.cc PROPERTIES HIP_SOURCE_PROPERTY_FORMAT 1)
  set_source_files_properties(src/runtime/cuda/cuda_device_api.cc PROPERTIES HIP_SOURCE_PROPERTY_FORMAT 1)

  file(GLOB_RECURSE DGL_HIP_SRC
    src/array/cuda/*.cc
    src/array/cuda/*.hip
    src/array/cuda/uvm/*.cc
    src/array/cuda/uvm/*.hip
    src/kernel/cuda/*.cc
    src/kernel/cuda/*.hip
    src/partition/cuda/*.hip
    src/runtime/cuda/*.cc
    src/runtime/cuda/*.hip
    src/geometry/cuda/*.hip
    src/graph/transform/cuda/*.hip
    src/graph/sampling/randomwalks/*.hip
  )

  find_library(DCU_RUNTIME galaxyhip ${ROCM_PATH}/lib)
  find_library(DCU_SPARSE hipsparse ${ROCM_PATH}/lib)
  find_library(DCU_BLAS hipblas ${ROCM_PATH}/lib)
  find_library(DCU_RAND hiprand ${ROCM_PATH}/lib)
  message(STATUS "Found DCU_RUNTIME: ${DCU_RUNTIME}")
  message(STATUS "Found DCU_SPARSE: ${DCU_SPARSE}")
  message(STATUS "Found DCU_BLAS: ${DCU_BLAS}")
  message(STATUS "Found DCU_RAND: ${DCU_RAND}")

  list(APPEND DGL_LINKER_LIBS
    ${DCU_RUNTIME}
    ${DCU_SPARSE}
    ${DCU_BLAS}
    ${DCU_RAND}
  )

  set(${out_variable} ${DGL_HIP_SRC})
endmacro()

