#!/bin/bash
# Helper script to build tensor adapter libraries for PyTorch
set -e

mkdir -p build
mkdir -p $BINDIR/tensoradapter/pytorch
cd build

if [ $(uname) = 'Darwin' ]; then
	CPSOURCE=*.dylib
else
	CPSOURCE=*.so
fi

CMAKE_FLAGS=" -DUSE_HIP=$USE_HIP"

if [ $# -eq 0 ]; then
	CC=hipcc CXX=hipcc $CMAKE_COMMAND $CMAKE_FLAGS ..
	make -j VERBOSE=1
	cp -v $CPSOURCE $BINDIR/tensoradapter/pytorch
else
	for PYTHON_INTERP in $@; do
		TORCH_VER=$($PYTHON_INTERP -c 'import torch; print(torch.__version__.split("+")[0])')
		mkdir -p $TORCH_VER
		cd $TORCH_VER
		CC=hipcc CXX=hipcc $CMAKE_COMMAND $CMAKE_FLAGS -DPYTHON_INTERP=$PYTHON_INTERP ../..
		make -j VERBOSE=1
		cp -v $CPSOURCE $BINDIR/tensoradapter/pytorch
		cd ..
	done
fi
