# DGL
## 简介
DGL 是一个易于使用、高性能且可扩展的 Python 软件包，用于基于图的深度学习。DGL 是框架无关的，这意味着如果深度图模型是端到端应用程序的一个组件，其余的逻辑可以在任何主要框架中实现。
* 基于图的库
* 适用于图神经网络的研究者和实践者的多用途工具。
* 易用、易学习

## 安装
组件支持：
* python3.10
### 1. 使用pip方式安装
dgl whl包下载目录：xxx, 择对应的pytorch版本和python版本下载对应的dgl的whl包
```
pip install dgl*.whl
```

### 2.使用源码编译的方式安装
#### 编译环境准备
环境准备可以参考如下方式：
1. 基于光源pytorch基础镜像环境：镜像下载地址：https://sourcefind.cn/#/image/dcu/pytorch，根据pytorch、python、dtk及系统下载对应的镜像版本。
2. 基于现有python环境：安装pytorch，pytorch whl包下载目录：https://cancon.hpccube.com:65024/4/main/pytorch/dtk24.04，根据python、dtk版本,下载对应pytorch的whl包。
安装torch、setuptools、wheel等
#### 源码编译
* 代码下载：
```
git clone http://developer.sourcefind.cn/codes/OpenDAS/dgl.git
```
并切换分支到：2.1.0-dtk24.04
* 源码编译安装
```
source /opt/dtk/env.sh
git submodule update --init --recursive
CC=hipcc CXX=hipcc cmake -DUSE_HIP=ON -DCMAKE_BUILD_TYPE=Release ..
# dtk 24.04.2时，使用以下cmake指令
#cmake -DCMAKE_C_COMPILER=hipcc -DCMAKE_CXX_COMPILER=hipcc -DCMAKE_HIP_COMPILER=dcc -DUSE_HIP=ON -DCMAKE_BUILD_TYPE=Release ..
make -j128 VERBOSE=1
cd ../python
python setup.py bdist_wheel
```
#### 注意事项
* torchdata 版本使用0.7
## 验证
* python -c "import dgl;dgl.__version__" ,版本号与官方版本同步，查询该软件的版本号
## Known Issue
* 无
## 参考资料
* [README_ORIGIN.MD](README_ORIGIN.MD)
* [https://github.com/dmlc/dgl](https://github.com/dmlc/dgl)