# <div aligh="center"><strong>Detectron2</strong></div>
## 简介
Detectron2 是 Facebook AI Research 的下一代软件系统实现最先进的对象检测算法

### 使用pip方式安装
- detectron2 whl包下载目录：[http://10.6.10.68:8000/customized/detectron2/dtk2310/](http://10.6.10.68:8000/customized/detectron2/dtk2310/). 目前只提供有python3.8, pytorch2.1版本的安装包 (内网whl包安装)
  ```shell
  pip install detectron2* (下载的detectron2的whl包)
  ```

- 也可以在光合[光合开发者社区](https://developer.hpccube.com/tool/#sdk) AI 生态包中获取最新的 detectron2 Release 版本（需对应 DCU Toolkit 版本与 python 版本）
  ```bash
  python3 -m pip install detectron2-0.1.3-cp38-cp38-linux_x86_64.whl
  ```
### 使用源码编译方式安装

#### 编译环境准备
- 安装相关依赖
  ```shell
  pip install numpy
  pip install 'urllib3==1.26.14'
  pip install wheel
  ```
- 拉取 detectron2 代码
  ```
  git clone -b v0.1.3-release http://developer.hpccube.com/codes/OpenDAS/detectron2.git
  ```


- 在首页 | 光合开发者社区下载 dtk23.10 解压在 /opt/ 路径下，并建立软连接，例如:
  在[开发者社区](https://developer.hpccube.com/tool/#sdk) DCU Toolkit 中下载 DTK-23.10 解压至 /opt/ 路径下，并建立软链接
  ```
  cd /opt && ln -s dtk-23.04 dtk
  ```

- 安装pytorch. pytorch whl包下载目录: [开发者社区](https://cancon.hpccube.com:65024/4/main/pytorch). 根据需求下载对应的版本，安装如下：
  ```shell
  pip install torch* (下载的torch的whl包)
  ```
#### 源码编译
- 方案一
  下载转码脚本pymap_script.py，[http://10.6.10.68:8000/debug/pytorch/dtk23.10/hipify](http://10.6.10.68:8000/debug/pytorch/dtk23.10/hipify) 
  ```shell
  python pymap_script.py /path/to/detectron2
  python -m pip install -e detectron2
  ```
- 方案二
  ```
  export FORCE_CUDA=1 #v0.1.3以前没有适配hip版本需要设置这个环境变量
  cd detectron2
  python setup.py install --user bdist_wheel
  pip install dist/detectron2*
  ```
## 单侧
```shell
cd detectron2
python -m unittest discover -v -s ./tests
```
## Known Issue
```
无
```
## 参考资料
```shell
https://github.com/facebookresearch/detectron2.git
```
