# <div align="center"><strong>Detectron2</strong></div>
## 简介
Detectron2 是 Facebook AI Research 的下一代软件系统实现最先进的对象检测算法

## 安装
组件支持组合

   | PyTorch版本 | fastpt版本  |Detectron2版本    | DTK版本        | Python版本       | 推荐编译方式 |
   | ----------- | ----------- | ---------------- | -------------- | ---------------- | ------------ |
   | 2.5.1       | 2.1.0       |v0.6              | >= 25.04       | 3.8、3.10、3.11  | fastpt不转码 |
   | 2.4.1       | 2.0.1       |v0.6              | >= 25.04       | 3.8、3.10、3.11  | fastpt不转码 |
   | 其他        | 其他        |其他              | 其他           | 3.8、3.10、3.11  | hip转码      |

+ pytorch版本大于2.4.1 && dtk版本大于25.04 推荐使用fastpt不转码编译。

安装相关依赖
  ```shell
  pip install numpy
  pip install 'urllib3==1.26.14'
  pip install wheel
  pip install opencv-python
  ```
### 1、使用pip方式安装
detectron2 whl包下载目录：[光和开发者社区](https://download.sourcefind.cn:65024/4/main/). 选择对应的pytorch版本和python版本下载对应detectron2的whl包
  ```shell
  pip install torch* (下载torch的whl包)
  pip install fastpt* --no-deps (下载fastpt的whl包)
  source /usr/local/bin/fastpt -E
  pip install detectron2* (下载的detectron2的whl包)
  ```
### 2、使用源码编译方式安装

#### 编译环境准备
提供基于fastpt不转码编译：

1. 基于光源pytorch基础镜像环境：镜像下载地址：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据pytorch、python、dtk及系统下载对应的镜像版本。

2. 基于现有python环境：安装pytorch，fastpt whl包下载目录：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据python、dtk版本,下载对应pytorch的whl包。安装命令如下：
  ```shell
  pip install torch* (下载torch的whl包)
  pip install fastpt* --no-deps (下载fastpt的whl包, 安装顺序，先安装torch，后安装fastpt)
  ```
#### 源码编译安装
- 代码下载
  ```shell
  http://developer.sourcefind.cn/codes/OpenDAS/detectron2.git # 根据编译需要切换分支
  ```
- 提供2种源码编译方式（进入detectron2目录）：
  1, 设置不转码编译环境变量
  ```shell
  export FORCE_CUDA=1
  source /usr/local/bin/fastpt -C
  ```
- 方案一 源码编译安装
  ```shell
  python -m pip install -e detectron2
  ```
- 方案二, 编译whl包
  ```shell
  cd detectron2
  pip install -e .
  python setup.py install --user bdist_wheel
  pip install dist/detectron2*
  ```
#### 注意事项
+ 若使用pip install下载安装过慢，可添加pypi清华源：-i https://pypi.tuna.tsinghua.edu.cn/simple/
+ ROCM_PATH为dtk的路径，默认为/opt/dtk

## 验证
- python -c "import detectron2; detectron2.\_\_version__"，版本号与官方版本同步，查询该软件的版本号，例如v0.6；

## 单侧
  ```shell
  cd detectron2
  python -m unittest discover -v -s ./tests
  ```
## Known Issue
- 无

## 参考资料
- [README_ORIGIN](README_ORIGIN.md)
- [https://github.com/facebookresearch/detectron2.git](https://github.com/facebookresearch/detectron2.git)
