# <div align="center"><strong>Detectron2</strong></div>
## 简介
Detectron2 是 Facebook AI Research 的下一代软件系统实现最先进的对象检测算法

## 安装
### 使用pip方式安装
- detectron2 whl包下载目录：[http://10.6.10.68:8000/customized/detectron2/dtk2310/](http://10.6.10.68:8000/customized/detectron2/dtk2310/). 目前只提供有python3.8, pytorch2.1版本的安装包 (内网whl包安装, 不保证链接一直有效，无安装包推荐源码编译)
  ```shell
  pip install detectron2* (下载的detectron2的whl包)
  ```

- 也可以在光合[光合开发者社区](https://developer.hpccube.com/tool/#sdk) AI 生态包中获取最新的 detectron2 Release 版本（需对应 DCU Toolkit 版本与 python 版本）
  ```bash
  python3 -m pip install detectron2-0.1.3-cp38-cp38-linux_x86_64.whl
  ```
### 使用源码编译方式安装

#### 编译环境准备
- 安装相关依赖
  ```shell
  pip install numpy
  pip install 'urllib3==1.26.14'
  pip install wheel
  ```
- 拉取 detectron2 代码
  ```
  git clone -b v0.6-release http://developer.hpccube.com/codes/OpenDAS/detectron2.git
  ```


- 在首页 | 光合开发者社区下载 dtk24.04 解压在 /opt/ 路径下，并建立软连接，例如:
  在[开发者社区](https://developer.hpccube.com/tool/#sdk) DCU Toolkit 中下载 DTK-24.04 解压至 /opt/ 路径下，并建立软链接
  ```
  cd /opt && ln -s dtk-24.04 dtk
  ```

- 安装pytorch. fastpt whl包下载目录: [开发者社区](https://das.sourcefind.cn:55011/portal/#/home). 根据需求下载对应的版本，
  以torch whl包为例[https://download.sourcefind.cn:65024/file/4/pytorch/DAS1.5/torch-2.4.1+das.opt2.dtk2504-cp310-cp310-manylinux_2_28_x86_64.whl](https://download.sourcefind.cn:65024/file/4/pytorch/DAS1.5/torch-2.4.1+das.opt2.dtk2504-cp310-cp310-manylinux_2_28_x86_64.whl)只提供例子，具体需要根据环境安装不同的whl包 安装如下：
  ```shell
  pip install torch* (下载的torch的whl包)
  pip install fastpt* (下载的fastpt的whl包，fastpt包安装在torch包后面)
  ```
#### 源码编译
- 方案一 (优先推荐方案一)
  ```shell
  export FORCE_CUDA=1
  export USE_FASTPT_CUDA=1 或者 export USE_FASTPT_CUDA=True (不同版本设置不同，第一种无效用第二种)
  python -m pip install -e detectron2 或者 cd detectron2 && pip install -e .
  ```
- 方案二
  ```
  export FORCE_CUDA=1
  export USE_FASTPT_CUDA=1
  cd detectron2
  python setup.py install --user bdist_wheel
  pip install dist/detectron2*
  ```
## 单侧
```shell
cd detectron2
python -m unittest discover -v -s ./tests
```
## Known Issue
```
无
```
## 参考资料
- [README_ORIGIN](README_ORIGIN.md)
- [https://github.com/facebookresearch/detectron2.git](https://github.com/facebookresearch/detectron2.git)
