#!/usr/bin/bash

# 驱动安装位置定位
kernel_check() {
    # 当前kernel版本
    kernel_version=`uname -r`
    # 驱动安装到的kernel
    drive_in_kernel=`find /lib/ | grep -E "hydcu|hycu" | head -n 1 | awk -F "/" '{print $4}'`

    if [ "$kernel_version" = "$drive_in_kernel" ]; then
        echo "驱动安装在当前kernel版本下, 符合正常情况。"
    else
        echo "你的内核可能有所变更，检查下环境是否是多个内核"
    fi
}