#!/bin/bash

function pkg_check() {
    local pkgs_debian=(dmidecode lshw pciutils numactl-devel ipmitool locate)
    local pkgs_centos=(dmidecode lshw pciutils numactl-dev ipmitool mlocate)
    local cmd=(dmidecode lshw lspci numactl ipmitool locate)

    for ((i=0; i<${#cmd[@]}; i++)); do
        if ! command -v ${cmd[i]} &>/dev/null; then
            if command -v apt-get &>/dev/null; then
                echo "没有${cmd[i]} 命令，请先安装${pkgs_debian[i]}"
                exit 0
                # apt-get install -y ${pkgs_debian[i]}
            elif command -v yum &>/dev/null; then
                echo "没有${cmd[i]} 命令，请先安装${pkgs_centos[i]}"
                # yum install -y ${pkgs_centos[i]}
                exit 0
            fi
        fi
    done
}