# DataFlow

DataFlow是一个数据准备系统，旨在从噪声数据源（PDF、纯文本、低质量问答）中解析，生成，加工并评估高质量数据，以提升大语言模型（LLMs）在特定领域的表现，支持预训练、监督微调（SFT）、强化学习训练以及基于知识库的RAG系统。

## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | 4.53.3 |
| vllm | 0.9.2+das.opt1.dtk25042 |
| torch | 2.5.1+das.opt1.dtk25042 |
| torchaudio | 2.5.1+das.opt1.dtk25042 |
| torchvision | 0.20.1+das.opt1.dtk25042 |
| flash_mla | 1.0.0+das.opt1.dtk25042 |

##安装
使用DCU实现推理，后端为vllm，命令如下：

```bash
docker run -it --shm-size 60g --network=host --name dataflow --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v $PWD:/home/ image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10  bash
git clone  https://developer.sourcefind.cn/codes/qteam/dataflow
cd dataflow
pip install -e .[vllm]
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

安装完成后，你可以用如下指令检查安装是否正确：
```bash
dataflow -v
```
如果安装正常，且DataFlow是最新的Release版，则会看到:
```bash
open-dataflow codebase version: 1.0.7
        Checking for updates...
        Local version : 1.0.7
        PyPI  version : 1.0.7
You are using the latest version: 1.0.7

```

## 参考资料
- https://github.com/OpenDCAI/DataFlow
