<h1 style="text-align: center;">cubvh</h1>

# 1 简介

cubvh 是一个CUDA Mesh BVH加速工具包。

# 2 编译安装方式

## 2.1 环境准备

当前组件在下面的环境下已验证编译成功：

| 序号 |     FastPT版本     | Pytorch版本 | DTK版本 |
| :--: | :----------------: | :---------: | :------: |
|  1  | 2.0.1+das.dtk25041 |    2.4.1    | dtk25041 |
|  2  | 2.0.1+das.dtk2504 |    2.4.1    | dtk2504 |

## 2.2 编译流程

### 2.2.1 基础环境检查

* 检查当前环境是否安装 DTK，若没有则需要安装 DTK，并确定当前环境下 DTK 的版本；
* 检查当前环境是否安装 Pytorch，若没有则需要安装 Pytorch，并确定当前环境下 Pytorch 的版本是否与 DTK 版本对应；
* 检查当前环境是否安装 FastPT，若没有则需要安装 FastPT，并确定当前环境下 FastPT 的版本是否与 Pytorch 的版本相对应；

### 2.2.2 cubvh 编译流程

* 安装依赖

```bash
pip install wheel
```

* 手动下载三方库 eigen 至 third_party 下（`git submodule update --init --recursive` 访问代码仓会失败）
* 执行命令编译组件：

```
python setup.py build
python setup.py install
```

### 2.2.3 编译 whl 包

可以通过执行下面的命令生成 whl 包：

```bash
python setup.py bdist_wheel # 该指令用于编译whl包，执行该指令时不必执行前两个指令
```

并通过下面的命令安装 cubvh:

```bash
pip install dist/cubvh-0.1.0-cp310-cp310-linux_x86_64.whl
```

# 3 组件测试

执行下面的命令测试组件：

```bash
pip install PyMCubes
pip install scikit-image
pip install kiui
pip install rtree

python test/extract_mesh_watertight.py /path/to/objFile(.obj 或 .ply 网格文件路径或目录)
python test/signed_distance.py
python test/unsigned_distance.py --N 100
```
