# <div align="center"><strong>cuBVH</strong></div>

## 1 简介

cuBVH 是一个 CUDA Mesh BVH 加速工具包。

## 2 安装

组件支持组合

| PyTorch版本 | fastpt版本 | cuBVH版本     | DTK版本  | Python版本      | 推荐编译方式 |
| ----------- | ---------- | ------------- | -------- | --------------- | ------------ |
| 2.5.1       | 2.1.0      | main-ee89d5fa-fastpt | >= 25.04 | 3.8、3.10、3.11 | fastpt不转码 |
| 2.4.1       | 2.0.1      | main-ee89d5fa-fastpt | >= 25.04 | 3.8、3.10、3.11 | fastpt不转码 |

+ pytorch 版本大于 2.4.1 && dtk 版本大于 25.04 推荐使用 fastpt 不转码编译。

### 2.1 使用pip方式安装

cuBVH whl 包下载目录：[光和开发者社区](https://download.sourcefind.cn:65024/4/main)，选择对应的 pytorch 版本和 python 版本下载对应 cuBVH 的 whl 包: 

```shell
pip install torch* # 下载torch的whl包
pip install fastpt* --no-deps # 下载fastpt的whl包
source  /usr/local/bin/fastpt -E
pip install cubvh* # 下载的cubvh-fastpt的whl包
```

### 2.2 使用源码编译方式安装

#### 2.2.1 编译环境准备

提供基于 fastpt 不转码编译：

1. 基于光源 pytorch 基础镜像环境：镜像下载地址：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据 pytorch、python、dtk 及系统下载对应的镜像版本。
2. 基于现有 python 环境：安装 pytorch，fastpt whl 包下载目录：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据 python、dtk 版本，下载对应 pytorch 的 whl 包。安装命令如下：

```shell
pip install torch* # 下载torch的whl包
pip install fastpt* --no-deps # 下载fastpt的whl包, 安装顺序，先安装torch，后安装fastpt
pip install setuptools==59.5.0 wheel
```

#### 2.2.2 源码编译安装

- 代码下载

```shell
git clone http://developer.sourcefind.cn/codes/OpenDAS/cubvh.git # 根据编译需要切换分支
```

- **手动下载三方库 eigen 至 third_party 下（git submodule update --init --recursive 访问代码仓会失败）**
- 提供2种源码编译方式（进入 cubvh 目录）：
  - 源码编译安装：

    ```bash
    source /usr/local/bin/fastpt -C

    python setup.py build
    python setup.py install
    ```
  - whl 包构建安装：

    ```bash
    source /usr/local/bin/fastpt -C

    python setup.py bdist_wheel # 该指令用于编译 whl 包
    pip install dist/cubvh-0.1.0-cp310-cp310-linux_x86_64.whl
    ```

#### 2.2.3 注意事项

+ ROCM_PATH 为 dtk 的路径，默认为 /opt/dtk；
+ 在 pytorch2.5.1 环境下编译需要支持 c++17 语法，打开setup.py文件，把文件中的 -std=c++14 修改为 -std=c++17。

## 3 验证

执行下面的命令测试组件：

```bash
source /usr/local/bin/fastpt -E

pip install PyMCubes
pip install scikit-image
pip install kiui
pip install rtree

python test/extract_mesh_watertight.py /path/to/objFile(.obj 或 .ply 网格文件路径或目录)
python test/signed_distance.py
python test/unsigned_distance.py --N 100
```

## 4 Known Issue

- 无

## 5 参考资料

- [readme_origin](readme_origin.md)
- [https://github.com/ashawkey/cubvh](https://github.com/ashawkey/cubvh)
