# <div align="center"><strong>BitsandTytes</strong></div>
## 简介
bitsandbytes 通过为 PyTorch 提供 k 比特量化技术，使得大型语言模型的使用更加便捷。我们提供了三大核心功能，可显著降低推理和训练过程中的内存消耗：8 比特优化器：采用分块量化（block-wise quantization）技术，在仅占用少量内存的情况下，保持与 32 比特相近的性能。LLM.int8() 或 8 比特量化：实现大型语言模型的高效推理，所需内存仅为原来的一半，且不会造成任何性能下降。该方法基于逐向量量化（vector-wise quantization），将大部分特征量化为 8 比特，同时对异常值（outliers）单独使用 16 比特矩阵乘法进行处理。QLoRA 或 4 比特量化：通过多种节省内存的技术实现大型语言模型的训练，同时不牺牲性能。该方法将模型量化至 4 比特，并插入少量可训练的低秩适配（LoRA）权重，从而支持模型微调。核心功能在DCU加速卡的可用性，还针对DCU特有的硬件架构进行了深度定制优化，这使得开发者能够以极低的成本，轻松实现应用程序在DCU加速卡上的快速迁移和性能提升。目前已适配支持Pytorch2.4.1. Pytorch2.5.1. Pytorch2.7.1

## 安装
组件支持组合

   | PyTorch版本 | fastpt版本  |bitsandbytes 版本     | DTK版本      | Python版本       | 推荐编译方式 |
   | ----------- | ----------- | -------------------- | ------------ | ---------------- | ------------ |
   | 2.5.1       | 2.1.0       |0.48.0                | >= 25.04     | 3.8、3.10、3.11  | fastpt不转码 |
   | 2.4.1       | 2.0.1       |0.48.0                | >= 25.04     | 3.8、3.10、3.11  | fastpt不转码 |
   | 其他        | 其他        | 其他                 | 其他         | 3.8、3.10、3.11  | hip转码      |

+ pytorch版本大于2.4.1 && dtk版本大于25.04 推荐使用fastpt不转码编译。

- 安装相关依赖
```shell
pip install 'urllib3==1.26.14'
pip install pytest
pip install wheel
pip install -r requirements.txt
```

### 使用pip方式安装
bitsandbytes whl包下载目录：[光合开发者社区](https://download.sourcefind.cn:65024/4/main/bitsandbytes)，选择对应的pytorch版本和python版本下载对应bitsandbytes的whl包
```shell
pip install torch* (下载torch的whl包)
pip install fastpt* --no-deps (下载fastpt的whl包)
source  /usr/local/bin/fastpt -E
pip install bitsandbytes* (下载的bitsandbytes的whl包)
```

### 使用源码编译方式安装

#### 编译环境准备
提供基于fastpt不转码编译：

1. 基于光源pytorch基础镜像环境：镜像下载地址：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据pytorch、python、dtk及系统下载对应的镜像版本。

2. 基于现有python环境：安装pytorch，fastpt whl包下载目录：[光合开发者社区](https://sourcefind.cn/#/image/dcu/pytorch)，根据python、dtk版本,下载对应pytorch的whl包。安装命令如下：
```shell
pip install torch* (下载torch的whl包)
pip install fastpt* --no-deps (下载fastpt的whl包, 安装顺序，先安装torch，后安装fastpt)
```
#### 源码编译安装
```shell
git clone http://developer.sourcefind.cn/codes/OpenDAS/bitsandbytes.git
```
- 提供2种源码编译方式（进入bitsandbytes目录）：
1. 设置不转码编译环境变量
```shell
source /usr/local/bin/fastpt -C
```

2. 编译whl包并安装
```shell
cd bitsandbytes
pip install -e .
python setup.py bdist_wheel
pip install dist/*.whl
```

3. 源码编译安装
```shell
python3 setup.py install
```
#### 注意事项
+ 若使用pip install下载安装过慢，可添加pypi清华源：-i https://pypi.tuna.tsinghua.edu.cn/simple/
+ ROCM_PATH为dtk的路径，默认为/opt/dtk

## 验证
python -c "import bitsandbytes; bitsandbytes.\_\_version__"，版本号与官方版本同步，查询该软件的版本号，例如0.48.0.dev0

## 单测
```shell
cd bitsandbytes
pytest -vs ./tests
```

## Known Issue
无

## 参考资料
[README_ORIGIN.md](README_ORIGIN.md)
[https://github.com/bitsandbytes-foundation/bitsandbytes](https://github.com/bitsandbytes-foundation/bitsandbytes)
