# <div align="center"><strong>AutoGPTQ</strong></div>
## 简介
AutoGPTQ 是一个用于4bit量化的三方组件。AutoGPTQ 提供了一种高效的解决方案来优化深度学习模型，使其更适合在资源受限的环境中运行。通过自动化的量化流程和灵活的配置选项，开发者可以轻松实现性能和准确性的平衡。
## 安装

### 使用源码编译方式安装

#### 编译环境准备
下载光源的镜像，起dcoker

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.3.0-ubuntu20.04-dtk24.04.2-py3.10

# <Image ID>用上面拉取docker镜像的ID替换
# <Host Path>主机端路径
# <Container Path>容器映射路径
docker run -it --name mydocker --shm-size=1024G -v /opt/hyhal:/opt/hyhal:ro --device=/dev/kfd --device=/dev/dri/ --cap-add=SYS_PTRACE --security-opt seccomp=unconfined --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v <Host Path>:<Container Path> <Image ID> /bin/bash                  
```
注：                      
1、docker启动  -v /opt/hyhal:/opt/hyhal  这个变量不能少                                
2、若使用 pip install 下载安装过慢，可添加源：-i https://pypi.tuna.tsinghua.edu.cn/simple/                              

#### 源码编译安装
- 代码下载
根据不同的需求下载不同的分支
- 提供2种源码编译方式（进入AutoGPTQ目录）：
```

1. 源码编译安装
pip3 install e .

2. 编译成whl包安装
# 安装wheel 
python3 setup.py bdist_wheel
cd dist && pip3 install auto_gptq*
```
#### 量化模型

方式1、

下载https://huggingface.co/datasets/llm-wizard/alpaca-gpt4-data-zh

```shell
python test_quant.py
```
方式2、
```shell
python quant_with_alpaca.py --pretrained_model_dir "/home/yang/DL_DATA/Yi/Yi-34B-Chat/" --quantized_model_dir "./Yi-34B-Chat-gptq" --quant_batch_size 4
```

## 支持模型
| Models   |            Sizes            |
| :------: | :-------------------------: |
| LLaMA-2  | 7B/13B/70B                  |
| LLaMA    | 7B/13B/30B/65B              |
| Mistral  | 7B                          |
| MPT      | 7B/30B                      |
| OPT      | 125m/1.3B/2.7B/6.7B/13B/30B |
| Bloom    | 560m/3B/7B/                 |
| GPTJ     | 6.7B                        |
| Yi       | 6B/34B                      |
| Qwen     | 1.8B/7B/14B/72B             |
| GPT NeoX | 20B                         |
| GPT-J    | 6B                          |
| Mixtral  | 8x7B                        |
| Baichuan | 7B/13B                      |
































