# <div align="center"><strong>AutoAWQ</strong></div>
## 简介
AutoAWQ 是一个用于4bit量化的三方组件。与FP16相比，AutoAWQ可以将模型速度提升3倍，内存需求减少3倍。AutoAWQ实现了激活感知权重量化（AWQ）算法，用于量化LLMs。AutoAWQ是基于麻省理工学院的[原始工作](https://github.com/mit-han-lab/llm-awq)进行改进和创建的。
## 安装

### 使用源码编译方式安装

#### 编译环境准备
下载光源的镜像，起dcoker

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310

# <Image ID>用上面拉取docker镜像的ID替换
# <Host Path>主机端路径
# <Container Path>容器映射路径
docker run -it --name mydocker --shm-size=1024G -v /opt/hyhal:/opt/hyhal:ro --device=/dev/kfd --device=/dev/dri/ --cap-add=SYS_PTRACE --security-opt seccomp=unconfined --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v <Host Path>:<Container Path> <Image ID> /bin/bash                  
```
注：                      
1、docker启动  -v /opt/hyhal:/opt/hyhal  这个变量不能少                                
2、若使用 pip install 下载安装过慢，可添加源：-i https://pypi.tuna.tsinghua.edu.cn/simple/                              

#### 源码编译安装
- 代码下载
根据不同的需求下载不同的分支
- 提供2种源码编译方式（进入AutoAWQ目录）：
```
#基础依赖安装：                      
pip install -r requirements.txt  

1. 源码编译安装
pip3 install e .

2. 编译成whl包安装
# 安装wheel 
python3 setup.py bdist_wheel
cd dist && pip3 install autoawq* --no-deps
```
## 支持模型
| Models   |            Sizes            |
| :------: | :-------------------------: |
| LLaMA-2  | 7B/13B/70B                  |
| LLaMA    | 7B/13B/30B/65B              |
| Mistral  | 7B                          |
| Vicuna   | 7B/13B                      |
| MPT      | 7B/30B                      |
| Falcon   | 7B/40B                      |
| OPT      | 125m/1.3B/2.7B/6.7B/13B/30B |
| Bloom    | 560m/3B/7B/                 |
| GPTJ     | 6.7B                        |
| Aquila   | 7B                          |
| Aquila2  | 7B/34B                      |
| Yi       | 6B/34B                      |
| Qwen     | 1.8B/7B/14B/72B             |
| BigCode  | 1B/7B/15B                   |
| GPT NeoX | 20B                         |
| GPT-J    | 6B                          |
| LLaVa    | 7B/13B                      |
| Mixtral  | 8x7B                        |
| Baichuan | 7B/13B                      |

## 验证
- python -c "import awq; print(awq.\_\_version__)"，版本号与官方版本同步，查询该软件的版本号，例如0.2.5；              

## Known Issue
- 无

## 参考资料
- [README](README.md)
- [https://github.com/casper-hansen/AutoAWQ](https://github.com/casper-hansen/AutoAWQ.git)





























