# APEX

# 1 简介
DAS软件栈提供DCU适配版的apex深度学习框架。得益于DAS软件栈对apex特性功能的支持，开发者针对DCU加速卡开发应用时，可以便捷调用apex用于简化Pytorch中的混合精度和分布式训练等功能。

# 2 编译安装方式

## 2.1 环境准备

当前组件在下面的环境下已验证编译成功：

| 序号 | FastPT版本 | Pytorch版本 | DTK版本 |
| :--: | :--------: | :---------: | :-----: |
|  1  | 2.1.0+das.dtk25041 |2.5.1|dtk25041|
|  2  | 2.1.0+das.dtk2504 |2.5.1|dtk2504|
|  3  | 2.0.1+das.dtk25041 |2.4.1|dtk25041|
|  4  | 2.0.1+das.dtk2504 |2.4.1|dtk2504|

## 2.2 编译流程

### 2.2.1 基础环境检查

* 检查当前环境是否安装 DTK，若没有则需要安装 DTK，并确定当前环境下 DTK 的版本；
* 检查当前环境是否安装 Pytorch，若没有则需要安装 Pytorch，并确定当前环境下 Pytorch 的版本是否与 DTK 版本对应；
* 检查当前环境是否安装 FastPT，若没有则需要安装 FastPT，并确定当前环境下 FastPT 的版本是否与 Pytorch 的版本相对应。

### 2.2.2 apex 编译流程
* 安装依赖
```bash
pip install wheel
pip install pytest

source /usr/local/bin/fastpt -C

python3 setup.py --cpp_ext --cuda_ext --peer_memory --nccl_p2p --fast_bottleneck bdist_wheel # 编译指令
```
并通过下面的命令安装 Pytorch3d:
```bash
pip install dist/apex-0.1-cp310-cp310-linux_x86_64.whl
```
# 3  组件测试
执行下面的命令测试组件：
```bash
pip install expecttest

source /usr/local/bin/fastpt -E

cd tests/L0
python run_test.py
```
